/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.SequencePlotter;
import adams.flow.source.FileSupplier;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaAccumulatedError;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaFileReader;
import adams.gui.visualization.sequence.LinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class WekaAccumulatedErrorTest
extends AbstractFlowTest {
    public WekaAccumulatedErrorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        super.tearDown();
    }

    public Actor getActor() {
        WekaClassifierSetup cls = new WekaClassifierSetup();
        cls.setName("cls");
        cls.setClassifier((Classifier)new J48());
        CallableActors ga = new CallableActors();
        ga.setActors(new Actor[]{cls});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new CallableActorReference("cls"));
        WekaAccumulatedError ae = new WekaAccumulatedError();
        SequencePlotter sp = new SequencePlotter();
        sp.setPaintlet((XYSequencePaintlet)new LinePaintlet());
        Flow flow = new Flow();
        flow.setActors(new Actor[]{ga, sfs, fr, cs, cv, ae, sp});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(WekaAccumulatedErrorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaAccumulatedErrorTest.runTest((Test)WekaAccumulatedErrorTest.suite());
    }
}

