/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.data.instancesanalysis.pls.AbstractSingleClassPLS;
import adams.data.instancesanalysis.pls.MatrixHelper;
import com.github.waikatodatamining.matrix.algorithm.pls.NIPALS;
import com.github.waikatodatamining.matrix.core.Matrix;
import com.github.waikatodatamining.matrix.core.PreprocessingType;
import java.util.Map;
import weka.core.Instances;

public class NIPALS
extends AbstractSingleClassPLS {
    private static final long serialVersionUID = -1605633160253194760L;
    protected com.github.waikatodatamining.matrix.algorithm.pls.NIPALS m_NIPALS;
    protected double m_Tol;
    protected int m_MaxIter;
    protected boolean m_NormYWeights;
    protected NIPALS.DeflationMode m_DeflationMode;

    public String globalInfo() {
        return "Nonlinear Iterative Partial Least Squares (NIPALS).\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "scikit-learn");
        result.setValue(TechnicalInformation.Field.TITLE, "Nonlinear Iterative Partial Least Squares (NIPALS)");
        result.setValue(TechnicalInformation.Field.URL, "https://github.com/scikit-learn/scikit-learn/blob/ed5e127b/sklearn/cross_decomposition/pls_.py#L455");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tol", "tol", (Object)1.0E-6, (Number)0.0, null);
        this.m_OptionManager.add("max-iter", "maxIter", (Object)500, (Number)1, null);
        this.m_OptionManager.add("norm-y-weights", "normYWeights", (Object)false);
        this.m_OptionManager.add("deflation-mode", "deflationMode", (Object)NIPALS.DeflationMode.REGRESSION);
    }

    public void setTol(double value) {
        if (this.getOptionManager().isValid("tol", (Number)value)) {
            this.m_Tol = value;
            this.reset();
        }
    }

    public double getTol() {
        return this.m_Tol;
    }

    public String tolTipText() {
        return "The inner NIPALS loop improvement tolerance.";
    }

    public void setMaxIter(int value) {
        if (this.getOptionManager().isValid("maxIter", (Number)value)) {
            this.m_MaxIter = value;
            this.reset();
        }
    }

    public int getMaxIter() {
        return this.m_MaxIter;
    }

    public String maxIterTipText() {
        return "The inner NIPALS loop maximum number of iterations.";
    }

    public void setNormYWeights(boolean value) {
        this.m_NormYWeights = value;
        this.reset();
    }

    public boolean getNormYWeights() {
        return this.m_NormYWeights;
    }

    public String normYWeightsTipText() {
        return "Whether to normalize Y weights.";
    }

    public void setDeflationMode(NIPALS.DeflationMode value) {
        this.m_DeflationMode = value;
        this.reset();
    }

    public NIPALS.DeflationMode getDeflationMode() {
        return this.m_DeflationMode;
    }

    public String deflationModeTipText() {
        return "The deflation mode to use.";
    }

    @Override
    public String[] getMatrixNames() {
        return this.m_NIPALS.getMatrixNames();
    }

    @Override
    public weka.core.matrix.Matrix getMatrix(String name) {
        return MatrixHelper.matrixAlgoToWeka(this.m_NIPALS.getMatrix(name));
    }

    @Override
    public boolean hasLoadings() {
        return this.m_NIPALS.hasLoadings();
    }

    @Override
    public weka.core.matrix.Matrix getLoadings() {
        return MatrixHelper.matrixAlgoToWeka(this.m_NIPALS.getLoadings());
    }

    @Override
    protected Instances doTransform(Instances data, Map<String, Object> params) throws Exception {
        Matrix X = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getX(data));
        Matrix y = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getY(data));
        if (!this.isInitialized()) {
            this.m_NIPALS = new com.github.waikatodatamining.matrix.algorithm.pls.NIPALS();
            this.m_NIPALS.setNumComponents(this.m_NumComponents);
            this.m_NIPALS.setPreprocessingType(PreprocessingType.NONE);
            this.m_NIPALS.setTol(this.m_Tol);
            this.m_NIPALS.setMaxIter(this.m_MaxIter);
            this.m_NIPALS.setNormYWeights(this.m_NormYWeights);
            this.m_NIPALS.setDeflationMode(this.m_DeflationMode);
            String error = this.m_NIPALS.initialize(X, y);
            if (error != null) {
                throw new Exception(error);
            }
        }
        Matrix X_new = this.m_NIPALS.transform(X);
        return MatrixHelper.toInstances(this.getOutputFormat(), MatrixHelper.matrixAlgoToWeka(X_new), MatrixHelper.matrixAlgoToWeka(y));
    }
}

