/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.core.option.OptionUtils;
import adams.data.instancesanalysis.pls.AbstractSingleClassPLS;
import adams.data.instancesanalysis.pls.MatrixHelper;
import com.github.waikatodatamining.matrix.algorithm.pls.AbstractPLS;
import com.github.waikatodatamining.matrix.algorithm.pls.PLS1;
import com.github.waikatodatamining.matrix.core.Matrix;
import com.github.waikatodatamining.matrix.core.PreprocessingType;
import java.util.Map;
import weka.core.Instances;

public class OPLS
extends AbstractSingleClassPLS {
    private static final long serialVersionUID = -1605633160253194760L;
    protected AbstractPLS m_Base;
    protected com.github.waikatodatamining.matrix.algorithm.pls.OPLS m_OPLS;

    public String globalInfo() {
        return "Orthogonal Projections to latent structures (O-PLS).\n\nFor more informatio see:\n" + this.getTechnicalInformation();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Johan Trygg and Svante Wold");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "Orthogonal projections to latent structures (O-PLS)");
        result.setValue(TechnicalInformation.Field.JOURNAL, "JOURNAL OF CHEMOMETRICS");
        result.setValue(TechnicalInformation.Field.VOLUME, "16");
        result.setValue(TechnicalInformation.Field.PAGES, "119-128");
        result.setValue(TechnicalInformation.Field.URL, "https://onlinelibrary.wiley.com/doi/pdf/10.1002/cem.695");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("base", "base", (Object)new PLS1());
    }

    public void setBase(AbstractPLS value) {
        this.m_Base = value;
        this.reset();
    }

    public AbstractPLS getBase() {
        return this.m_Base;
    }

    public String baseTipText() {
        return "The base PLS algorithm to use.";
    }

    @Override
    public String[] getMatrixNames() {
        return this.m_OPLS.getMatrixNames();
    }

    @Override
    public weka.core.matrix.Matrix getMatrix(String name) {
        return MatrixHelper.matrixAlgoToWeka(this.m_OPLS.getMatrix(name));
    }

    @Override
    public boolean hasLoadings() {
        return this.m_OPLS.hasLoadings();
    }

    @Override
    public weka.core.matrix.Matrix getLoadings() {
        return MatrixHelper.matrixAlgoToWeka(this.m_OPLS.getLoadings());
    }

    @Override
    public Instances determineOutputFormat(Instances input) throws Exception {
        this.m_OutputFormat = new Instances(input, 0);
        return this.m_OutputFormat;
    }

    @Override
    protected Instances doTransform(Instances data, Map<String, Object> params) throws Exception {
        Matrix X = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getX(data));
        Matrix y = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getY(data));
        if (!this.isInitialized()) {
            this.m_OPLS = new com.github.waikatodatamining.matrix.algorithm.pls.OPLS();
            this.m_OPLS.setNumComponents(this.m_NumComponents);
            this.m_OPLS.setPreprocessingType(PreprocessingType.NONE);
            this.m_OPLS.setBasePLS((AbstractPLS)OptionUtils.shallowCopy((Object)this.m_Base));
            String error = this.m_OPLS.initialize(X, y);
            if (error != null) {
                throw new Exception(error);
            }
        }
        Matrix X_new = this.m_OPLS.transform(X);
        return MatrixHelper.toInstances(this.getOutputFormat(), MatrixHelper.matrixAlgoToWeka(X_new), MatrixHelper.matrixAlgoToWeka(y));
    }
}

