/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.core.Utils;
import adams.data.instancesanalysis.pls.AbstractSingleClassPLS;
import java.util.Map;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.matrix.Matrix;
import weka.core.matrix.MatrixHelper;

public class PLS1
extends AbstractSingleClassPLS {
    private static final long serialVersionUID = -2148100447010845646L;
    protected Matrix m_r_hat;
    protected Matrix m_P;
    protected Matrix m_W;
    protected Matrix m_b_hat;

    public String globalInfo() {
        return "Implementation of PLS1 algorithm.\n\nAvailable matrices: " + Utils.flatten((Object[])this.getMatrixNames(), (String)", ") + "\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Tormod Naes and Tomas Isaksson and Tom Fearn and Tony Davies");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.TITLE, "A User Friendly Guide to Multivariate Calibration and Classification");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "NIR Publications");
        result.setValue(TechnicalInformation.Field.ISBN, "0-9528666-2-5");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.MISC);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "StatSoft, Inc.");
        additional.setValue(TechnicalInformation.Field.TITLE, "Partial Least Squares (PLS)");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Electronic Textbook StatSoft");
        additional.setValue(TechnicalInformation.Field.HTTP, "http://www.statsoft.com/textbook/stpls.html");
        additional = result.add(TechnicalInformation.Type.MISC);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Bent Jorgensen and Yuri Goegebeur");
        additional.setValue(TechnicalInformation.Field.TITLE, "Module 7: Partial least squares regression I");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "ST02: Multivariate Data Analysis and Chemometrics");
        additional.setValue(TechnicalInformation.Field.HTTP, "http://statmaster.sdu.dk/courses/ST02/module07/");
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_r_hat = null;
        this.m_P = null;
        this.m_W = null;
        this.m_b_hat = null;
    }

    @Override
    public String[] getMatrixNames() {
        return new String[]{"r_hat", "P", "W", "b_hat"};
    }

    @Override
    public Matrix getMatrix(String name) {
        switch (name) {
            case "RegVector": {
                return this.m_r_hat;
            }
            case "P": {
                return this.m_P;
            }
            case "W": {
                return this.m_W;
            }
            case "b_hat": {
                return this.m_b_hat;
            }
        }
        return null;
    }

    @Override
    public boolean hasLoadings() {
        return true;
    }

    @Override
    public Matrix getLoadings() {
        return this.getMatrix("P");
    }

    protected Instances predict(Instances data) {
        Instances result = new Instances(this.getOutputFormat());
        for (int i = 0; i < data.numInstances(); ++i) {
            Instances tmpInst = new Instances(data, 0);
            tmpInst.add((Instance)data.instance(i).copy());
            Matrix x = MatrixHelper.getX(tmpInst);
            Matrix X = new Matrix(1, this.getNumComponents());
            Matrix T = new Matrix(1, this.getNumComponents());
            for (int j = 0; j < this.getNumComponents(); ++j) {
                MatrixHelper.setVector(x, X, j);
                Matrix t = x.times(MatrixHelper.getVector(this.m_W, j));
                MatrixHelper.setVector(t, T, j);
                x = x.minus(MatrixHelper.getVector(this.m_P, j).transpose().times(t.get(0, 0)));
            }
            switch (this.m_PredictionType) {
                case ALL: {
                    tmpInst = MatrixHelper.toInstances(this.getOutputFormat(), T, T.times(this.m_b_hat));
                    break;
                }
                case NONE: 
                case EXCEPT_CLASS: {
                    tmpInst = MatrixHelper.toInstances(this.getOutputFormat(), T, MatrixHelper.getY(tmpInst));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled prediction type: " + (Object)((Object)this.m_PredictionType));
                }
            }
            result.add(tmpInst.instance(0));
        }
        return result;
    }

    @Override
    protected Instances doTransform(Instances data, Map<String, Object> params) throws Exception {
        Instances result;
        if (!this.isInitialized()) {
            Matrix X = MatrixHelper.getX(data);
            Matrix y = MatrixHelper.getY(data);
            Matrix X_trans = X.transpose();
            Matrix W = new Matrix(data.numAttributes() - 1, this.getNumComponents());
            Matrix P = new Matrix(data.numAttributes() - 1, this.getNumComponents());
            Matrix T = new Matrix(data.numInstances(), this.getNumComponents());
            Matrix b_hat = new Matrix(this.getNumComponents(), 1);
            for (int j = 0; j < this.getNumComponents(); ++j) {
                Matrix w = X_trans.times(y);
                MatrixHelper.normalizeVector(w);
                MatrixHelper.setVector(w, W, j);
                Matrix t = X.times(w);
                Matrix t_trans = t.transpose();
                MatrixHelper.setVector(t, T, j);
                double b = t_trans.times(y).get(0, 0) / t_trans.times(t).get(0, 0);
                b_hat.set(j, 0, b);
                Matrix p = X_trans.times(t).times(1.0 / t_trans.times(t).get(0, 0));
                Matrix p_trans = p.transpose();
                MatrixHelper.setVector(p, P, j);
                X = X.minus(t.times(p_trans));
                y = y.minus(t.times(b));
            }
            Matrix tmp = W.times(P.transpose().times(W).inverse());
            this.m_r_hat = tmp.times(b_hat);
            this.m_P = P;
            this.m_W = W;
            this.m_b_hat = b_hat;
            result = this.predict(data);
        } else {
            result = this.predict(data);
        }
        return result;
    }
}

