/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis.pls;

import adams.core.TechnicalInformation;
import adams.data.instancesanalysis.pls.AbstractSingleClassPLS;
import adams.data.instancesanalysis.pls.MatrixHelper;
import adams.data.instancesanalysis.pls.PreprocessingType;
import com.github.waikatodatamining.matrix.core.Matrix;
import java.util.Map;
import weka.core.Instances;

public class PRM
extends AbstractSingleClassPLS {
    private static final long serialVersionUID = -1605633160253194760L;
    protected com.github.waikatodatamining.matrix.algorithm.pls.PRM m_PRM;
    protected double m_Tol;
    protected int m_MaxIter;
    protected int m_NumSimplsCoefficients;
    protected double m_C;

    public String globalInfo() {
        return "Partial robust M-regression (PRM).\nFor more information see:\n" + this.getTechnicalInformation();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Sven Serneels, Christophe Croux, Peter Filzmoser, Pierre J.Van Espen");
        result.setValue(TechnicalInformation.Field.YEAR, "2005");
        result.setValue(TechnicalInformation.Field.TITLE, "Partial robust M-regression");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Chemometrics and Intelligent Laboratory Systems");
        result.setValue(TechnicalInformation.Field.VOLUME, "79");
        result.setValue(TechnicalInformation.Field.PAGES, "55-64");
        result.setValue(TechnicalInformation.Field.URL, "https://www.sciencedirect.com/science/article/pii/S0169743905000638");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tol", "tol", (Object)1.0E-6, (Number)0.0, null);
        this.m_OptionManager.add("max-iter", "maxIter", (Object)500, (Number)1, null);
        this.m_OptionManager.add("num-simpls-coefficients", "numSimplsCoefficients", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("c", "c", (Object)4.0, (Number)1.0E-10, null);
    }

    @Override
    protected PreprocessingType getDefaultPreprocessingType() {
        return PreprocessingType.NONE;
    }

    public void setTol(double value) {
        if (this.getOptionManager().isValid("tol", (Number)value)) {
            this.m_Tol = value;
            this.reset();
        }
    }

    public double getTol() {
        return this.m_Tol;
    }

    public String tolTipText() {
        return "The inner NIPALS loop improvement tolerance.";
    }

    public void setMaxIter(int value) {
        if (this.getOptionManager().isValid("maxIter", (Number)value)) {
            this.m_MaxIter = value;
            this.reset();
        }
    }

    public int getMaxIter() {
        return this.m_MaxIter;
    }

    public String maxIterTipText() {
        return "The inner NIPALS loop maximum number of iterations.";
    }

    public void setNumSimplsCoefficients(int value) {
        if (this.getOptionManager().isValid("numSimplsCoefficients", (Number)value)) {
            this.m_NumSimplsCoefficients = value;
            this.reset();
        }
    }

    public int getNumSimplsCoefficients() {
        return this.m_NumSimplsCoefficients;
    }

    public String numSimplsCoefficientsTipText() {
        return "The number of SIMPLS coefficients to keep; <= 0 to keep all.";
    }

    public void setC(double value) {
        if (this.getOptionManager().isValid("c", (Number)value)) {
            this.m_C = value;
            this.reset();
        }
    }

    public double getC() {
        return this.m_C;
    }

    public String CTipText() {
        return "The tuning parameter, >0.";
    }

    @Override
    public String[] getMatrixNames() {
        return this.m_PRM.getMatrixNames();
    }

    @Override
    public weka.core.matrix.Matrix getMatrix(String name) {
        return MatrixHelper.matrixAlgoToWeka(this.m_PRM.getMatrix(name));
    }

    @Override
    public boolean hasLoadings() {
        return this.m_PRM.hasLoadings();
    }

    @Override
    public weka.core.matrix.Matrix getLoadings() {
        return MatrixHelper.matrixAlgoToWeka(this.m_PRM.getLoadings());
    }

    @Override
    protected Instances doTransform(Instances data, Map<String, Object> params) throws Exception {
        Matrix X = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getX(data));
        Matrix y = MatrixHelper.wekaToMatrixAlgo(MatrixHelper.getY(data));
        if (!this.isInitialized()) {
            this.m_PRM = new com.github.waikatodatamining.matrix.algorithm.pls.PRM();
            this.m_PRM.setNumComponents(this.m_NumComponents);
            this.m_PRM.setPreprocessingType(com.github.waikatodatamining.matrix.core.PreprocessingType.NONE);
            this.m_PRM.setTol(this.m_Tol);
            this.m_PRM.setMaxIter(this.m_MaxIter);
            this.m_PRM.setNumSimplsCoefficients(this.m_NumSimplsCoefficients);
            this.m_PRM.setC(this.m_C);
            String error = this.m_PRM.initialize(X, y);
            if (error != null) {
                throw new Exception(error);
            }
        }
        Matrix X_new = this.m_PRM.transform(X);
        return MatrixHelper.toInstances(this.getOutputFormat(), MatrixHelper.matrixAlgoToWeka(X_new), MatrixHelper.matrixAlgoToWeka(y));
    }
}

