/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.SerializationHelper;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractAdamsExperimentReader;
import adams.data.io.output.AbstractAdamsExperimentWriter;
import adams.data.io.output.SerializedAdamsExperimentWriter;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractExperiment;
import java.util.logging.Level;

public class SerializedAdamsExperimentReader
extends AbstractAdamsExperimentReader {
    private static final long serialVersionUID = 7175000296488786947L;

    public String globalInfo() {
        return "Reads serialized ADAMS Experiments.";
    }

    @Override
    public String getFormatDescription() {
        return "Serialized experiment";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"expser"};
    }

    @Override
    public AbstractAdamsExperimentWriter getCorrespondingWriter() {
        return new SerializedAdamsExperimentWriter();
    }

    @Override
    protected AbstractExperiment doRead(PlaceholderFile file) {
        try {
            return (AbstractExperiment)SerializationHelper.read((String)file.getAbsolutePath());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load experiment from: " + file, (Throwable)e);
            return null;
        }
    }
}

