/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.option.OptionUtils;
import adams.core.option.WekaCommandLineHandler;
import adams.flow.core.AbstractPropertyValueConverter;
import java.lang.reflect.Array;
import nz.ac.waikato.cms.locator.ClassLocator;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.Classifier;
import weka.clusterers.Clusterer;
import weka.core.OptionHandler;
import weka.filters.Filter;

public class WekaPropertyValueConverter
extends AbstractPropertyValueConverter {
    private static final long serialVersionUID = 5709690907332699331L;
    protected WekaCommandLineHandler m_CommandLineHandler;

    protected void initialize() {
        super.initialize();
        this.m_CommandLineHandler = new WekaCommandLineHandler();
    }

    public boolean handles(Class cls) {
        if (cls.isArray()) {
            return this.handles(cls.getComponentType());
        }
        if (ClassLocator.hasInterface(OptionHandler.class, (Class)cls)) {
            return true;
        }
        if (cls == Classifier.class) {
            return true;
        }
        if (cls == Clusterer.class) {
            return true;
        }
        if (cls == Filter.class) {
            return true;
        }
        if (cls == ASSearch.class) {
            return true;
        }
        return cls == ASEvaluation.class;
    }

    public Object convert(Class cls, String value) throws Exception {
        if (cls.isArray()) {
            String[] values = OptionUtils.splitOptions((String)value);
            Object result = Array.newInstance(cls.getComponentType(), values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(result, i, this.convert(cls.getComponentType(), values[i]));
            }
            return result;
        }
        return this.m_CommandLineHandler.fromCommandLine(value);
    }
}

