/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.weka.WekaLabelRange;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Level;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.CostCurve;
import weka.core.Instances;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class WekaCostCurve
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected ThresholdVisualizePanel m_VisualizePanel;
    protected WekaLabelRange m_ClassLabelRange;

    public String globalInfo() {
        return "Actor for displaying a cost curve.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "classLabelRange", (Object)new WekaLabelRange("first"));
    }

    protected void initialize() {
        super.initialize();
        this.m_ClassLabelRange = new WekaLabelRange("first");
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void setClassLabelRange(WekaLabelRange value) {
        this.m_ClassLabelRange = value;
        this.reset();
    }

    public WekaLabelRange getClassLabelRange() {
        return this.m_ClassLabelRange;
    }

    public String classLabelRangeTipText() {
        return "The indices of the class labels to use for the plot.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classLabelRange", (Object)((Object)this.m_ClassLabelRange), (String)", class label: ");
        return result;
    }

    public void clearPanel() {
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_VisualizePanel = new ThresholdVisualizePanel();
        result.add((Component)this.m_VisualizePanel, (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected void display(Token token) {
        try {
            int[] indices;
            Evaluation eval = token.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation") : (Evaluation)token.getPayload();
            if (eval.predictions() == null) {
                this.getLogger().severe("No predictions available from Evaluation object!");
                return;
            }
            this.m_ClassLabelRange.setData(eval.getHeader().classAttribute());
            for (int index : indices = this.m_ClassLabelRange.getIntIndices()) {
                CostCurve curve = new CostCurve();
                Instances data = curve.getCurve(eval.predictions(), index);
                PlotData2D plot = new PlotData2D(data);
                plot.setPlotName(eval.getHeader().classAttribute().value(index));
                plot.m_displayAllPoints = true;
                boolean[] connectPoints = new boolean[data.numInstances()];
                for (int cp = 1; cp < connectPoints.length; ++cp) {
                    connectPoints[cp] = true;
                }
                plot.setConnectPoints(connectPoints);
                this.m_VisualizePanel.addPlot(plot);
            }
        }
        catch (Exception e) {
            this.handleException("Failed to display token: " + token, e);
        }
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
            this.m_VisualizePanel = null;
        }
    }

    protected Evaluation getEvaluation(Token token) {
        if (token.getPayload() instanceof WekaEvaluationContainer) {
            return (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation");
        }
        return (Evaluation)token.getPayload();
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        String name = token != null ? "Cost curve (" + this.getEvaluation(token).getHeader().relationName() + ")" : "Cost curve";
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(name){
            private static final long serialVersionUID = -3513994354297811163L;
            protected VisualizePanel m_VisualizePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_VisualizePanel = new VisualizePanel();
                this.add((Component)this.m_VisualizePanel, "Center");
            }

            public void display(Token token) {
                try {
                    int[] indices;
                    Evaluation eval = WekaCostCurve.this.getEvaluation(token);
                    WekaCostCurve.this.m_ClassLabelRange.setMax(eval.getHeader().classAttribute().numValues());
                    for (int index : indices = WekaCostCurve.this.m_ClassLabelRange.getIntIndices()) {
                        CostCurve curve = new CostCurve();
                        Instances data = curve.getCurve(eval.predictions(), index);
                        PlotData2D plot = new PlotData2D(data);
                        plot.setPlotName(eval.getHeader().classAttribute().value(index));
                        plot.m_displayAllPoints = true;
                        boolean[] connectPoints = new boolean[data.numInstances()];
                        for (int cp = 1; cp < connectPoints.length; ++cp) {
                            connectPoints[cp] = true;
                        }
                        plot.setConnectPoints(connectPoints);
                        this.m_VisualizePanel.addPlot(plot);
                    }
                }
                catch (Exception e) {
                    WekaCostCurve.this.getLogger().log(Level.SEVERE, "Failed to display token: " + token, (Throwable)e);
                }
            }

            public JComponent supplyComponent() {
                return this.m_VisualizePanel;
            }

            public void clearPanel() {
                this.m_VisualizePanel.removeAllPlots();
            }

            public void cleanUp() {
                this.m_VisualizePanel.removeAllPlots();
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }
}

