/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.weka.WekaAttributeIndex;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import weka.core.Instances;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class WekaInstancesPlot
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected VisualizePanel m_VisualizePanel;
    protected WekaAttributeIndex m_AttributeX;
    protected WekaAttributeIndex m_AttributeY;

    public String globalInfo() {
        return "Actor for plotting one attribute vs another.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("attribute-x", "attributeX", (Object)new WekaAttributeIndex("1"));
        this.m_OptionManager.add("attribute-y", "attributeY", (Object)new WekaAttributeIndex("2"));
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void setAttributeX(WekaAttributeIndex value) {
        this.m_AttributeX = value;
        this.reset();
    }

    public WekaAttributeIndex getAttributeX() {
        return this.m_AttributeX;
    }

    public String attributeXTipText() {
        return "The attribute to show on the X axis.";
    }

    public void setAttributeY(WekaAttributeIndex value) {
        this.m_AttributeY = value;
        this.reset();
    }

    public WekaAttributeIndex getAttributeY() {
        return this.m_AttributeY;
    }

    public String attributeYTipText() {
        return "The attribute to show on the Y axis.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"attributeX", (Object)((Object)this.m_AttributeX), (String)", x-axis: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"attributeY", (Object)((Object)this.m_AttributeY), (String)", y-axis: ");
        return result;
    }

    public void clearPanel() {
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_VisualizePanel = new VisualizePanel();
        result.add((Component)this.m_VisualizePanel, (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected void display(Token token) {
        try {
            Instances data = (Instances)token.getPayload();
            this.m_AttributeX.setData(data);
            this.m_AttributeY.setData(data);
            PlotData2D plot = new PlotData2D(data);
            if (this.m_AttributeX.getIntIndex() != -1 && this.m_AttributeY.getIntIndex() != -1) {
                plot.setPlotName(data.attribute(this.m_AttributeX.getIntIndex()).name() + " vs " + data.attribute(this.m_AttributeX.getIntIndex()).name());
            }
            plot.m_displayAllPoints = true;
            this.m_VisualizePanel.addPlot(plot);
            if (this.m_AttributeX.getIntIndex() != -1) {
                this.m_VisualizePanel.setXIndex(this.m_AttributeX.getIntIndex());
            }
            if (this.m_AttributeY.getIntIndex() != -1) {
                this.m_VisualizePanel.setYIndex(this.m_AttributeY.getIntIndex());
            }
        }
        catch (Exception e) {
            this.handleException("Failed to display token: " + token, e);
        }
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
            this.m_VisualizePanel = null;
        }
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        String name = "Instances plot";
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(name){
            private static final long serialVersionUID = -7362768698548152899L;
            protected VisualizePanel m_VisualizePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_VisualizePanel = new VisualizePanel();
                this.add((Component)this.m_VisualizePanel, "Center");
            }

            public void display(Token token) {
                try {
                    Instances data = (Instances)token.getPayload();
                    WekaInstancesPlot.this.m_AttributeX.setData(data);
                    WekaInstancesPlot.this.m_AttributeY.setData(data);
                    PlotData2D plot = new PlotData2D(data);
                    if (WekaInstancesPlot.this.m_AttributeX.getIntIndex() != -1 && WekaInstancesPlot.this.m_AttributeY.getIntIndex() != -1) {
                        plot.setPlotName(data.attribute(WekaInstancesPlot.this.m_AttributeX.getIntIndex()).name() + " vs " + data.attribute(WekaInstancesPlot.this.m_AttributeX.getIntIndex()).name());
                    }
                    plot.m_displayAllPoints = true;
                    this.m_VisualizePanel.addPlot(plot);
                    if (WekaInstancesPlot.this.m_AttributeX.getIntIndex() != -1) {
                        this.m_VisualizePanel.setXIndex(WekaInstancesPlot.this.m_AttributeX.getIntIndex());
                    }
                    if (WekaInstancesPlot.this.m_AttributeY.getIntIndex() != -1) {
                        this.m_VisualizePanel.setYIndex(WekaInstancesPlot.this.m_AttributeY.getIntIndex());
                    }
                }
                catch (Exception e) {
                    WekaInstancesPlot.this.handleException("Failed to display token: " + token, e);
                }
            }

            public JComponent supplyComponent() {
                return this.m_VisualizePanel;
            }

            public void clearPanel() {
                this.m_VisualizePanel.removeAllPlots();
            }

            public void cleanUp() {
                this.m_VisualizePanel.removeAllPlots();
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }
}

