/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSourceWithPropertiesUpdating;
import weka.core.Instances;
import weka.datagenerators.DataGenerator;
import weka.datagenerators.classifiers.classification.Agrawal;

public class WekaDataGenerator
extends AbstractSimpleSourceWithPropertiesUpdating {
    private static final long serialVersionUID = 1862828539481494711L;
    protected DataGenerator m_DataGenerator;

    public String globalInfo() {
        return "Generates artificial data using a Weka data generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "dataGenerator", (Object)new Agrawal());
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        if (!result.isEmpty()) {
            result = result + ", ";
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)Shortening.shortenEnd((String)OptionUtils.getShortCommandLine((Object)this.m_DataGenerator), (int)40));
        return result;
    }

    public void setDataGenerator(DataGenerator value) {
        this.m_DataGenerator = value;
        this.reset();
    }

    public DataGenerator getDataGenerator() {
        return this.m_DataGenerator;
    }

    public String dataGeneratorTipText() {
        return "The data generator to use for generating the weka.core.Instances object.";
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    protected String doExecute() {
        String result;
        this.m_OutputToken = null;
        try {
            result = this.setUpContainersIfNecessary(this.m_DataGenerator);
            if (result == null) {
                result = this.updateObject(this.m_DataGenerator);
            }
            if (result == null) {
                this.m_DataGenerator.setDatasetFormat(this.m_DataGenerator.defineDataFormat());
                Instances data = this.m_DataGenerator.generateExamples();
                if (data == null) {
                    result = "No data obtained from data generator!";
                } else {
                    this.m_OutputToken = new Token((Object)data);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate data: ", e);
        }
        return result;
    }
}

