/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.base.BaseDouble;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.Percentile;
import adams.data.weka.WekaLabelIndex;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.EvaluationHelper;
import adams.flow.core.EvaluationStatistic;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class WekaBootstrapping
extends AbstractTransformer
implements Randomizable {
    private static final long serialVersionUID = 2599800854948082354L;
    protected long m_Seed;
    protected int m_NumSubSamples;
    protected double m_Percentage;
    protected EvaluationStatistic[] m_StatisticValues;
    protected WekaLabelIndex m_ClassIndex;
    protected BaseDouble[] m_Percentiles;
    protected ErrorCalculation m_ErrorCalculation;
    protected boolean m_WithReplacement;

    public String globalInfo() {
        return "Performs bootstrapping on the incoming evaluation and outputs a spreadsheet where each row represents the results from bootstrapping sub-sample.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("num-subsamples", "numSubSamples", (Object)10, (Number)1, null);
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)1.0E-4, (Number)1.0);
        this.m_OptionManager.add("statistic", "statisticValues", (Object)new EvaluationStatistic[0]);
        this.m_OptionManager.add("class-index", "classIndex", (Object)new WekaLabelIndex("first"));
        this.m_OptionManager.add("percentile", "percentiles", (Object)new BaseDouble[0]);
        this.m_OptionManager.add("error-calculation", "errorCalculation", (Object)ErrorCalculation.ACTUAL_MINUS_PREDICTED);
        this.m_OptionManager.add("with-replacement", "withReplacement", (Object)true);
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed for generating the random sub-samples.";
    }

    public void setNumSubSamples(int value) {
        if (this.getOptionManager().isValid("numSubSamples", (Number)value)) {
            this.m_NumSubSamples = value;
            this.reset();
        }
    }

    public int getNumSubSamples() {
        return this.m_NumSubSamples;
    }

    public String numSubSamplesTipText() {
        return "The number of random sub-samples to generate.";
    }

    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage of the sub-sample size (between 0 and 1).";
    }

    public void setStatisticValues(EvaluationStatistic[] value) {
        this.m_StatisticValues = value;
        this.reset();
    }

    public EvaluationStatistic[] getStatisticValues() {
        return this.m_StatisticValues;
    }

    public String statisticValuesTipText() {
        return "The evaluation values to extract and turn into a spreadsheet.";
    }

    public void setClassIndex(WekaLabelIndex value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public WekaLabelIndex getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The index of class label (eg used for AUC).";
    }

    public void setPercentiles(BaseDouble[] value) {
        this.m_Percentiles = value;
        this.reset();
    }

    public BaseDouble[] getPercentiles() {
        return this.m_Percentiles;
    }

    public String percentilesTipText() {
        return "The percentiles to calculate for the errors (0-1; 0.95 is 95th percentile).";
    }

    public void setErrorCalculation(ErrorCalculation value) {
        this.m_ErrorCalculation = value;
        this.reset();
    }

    public ErrorCalculation getErrorCalculation() {
        return this.m_ErrorCalculation;
    }

    public String errorCalculationTipText() {
        return "Determines how to calculate the error.";
    }

    public void setWithReplacement(boolean value) {
        this.m_WithReplacement = value;
        this.reset();
    }

    public boolean getWithReplacement() {
        return this.m_WithReplacement;
    }

    public String withReplacementTipText() {
        return "If enabled, predictions are drawn using with replacement (i.e., duplicates are possible).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)"seed: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numSubSamples", (Object)this.m_NumSubSamples, (String)", # sub: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"percentage", (Object)this.m_Percentage, (String)", percentage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"statisticValues", (Object)(this.m_StatisticValues.length + " statistic" + (this.m_StatisticValues.length != 1 ? "s" : "")), (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classIndex", (Object)((Object)this.m_ClassIndex), (String)", class label: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"percentiles", (Object)(this.m_Percentiles.length + " percentile" + (this.m_Percentiles.length != 1 ? "s" : "")), (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"errorCalculation", (Object)((Object)this.m_ErrorCalculation), (String)", errors: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        Evaluation evalAll;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof Evaluation) {
            evalAll = (Evaluation)this.m_InputToken.getPayload();
        } else {
            WekaEvaluationContainer cont = (WekaEvaluationContainer)((Object)this.m_InputToken.getPayload());
            evalAll = (Evaluation)cont.getValue("Evaluation");
        }
        if (evalAll.predictions() == null || evalAll.predictions().size() == 0) {
            result = "No predictions available!";
        }
        if (result == null) {
            int i;
            DefaultSpreadSheet sheet = new DefaultSpreadSheet();
            HeaderRow row = sheet.getHeaderRow();
            row.addCell("S").setContentAsString("Subsample");
            for (EvaluationStatistic s : this.m_StatisticValues) {
                row.addCell(s.toString()).setContentAsString(s.toString());
            }
            block23: for (i = 0; i < this.m_Percentiles.length; ++i) {
                switch (this.m_ErrorCalculation) {
                    case ACTUAL_MINUS_PREDICTED: {
                        row.addCell("perc-AmP-" + i).setContentAsString("Percentile-AmP-" + this.m_Percentiles[i]);
                        continue block23;
                    }
                    case PREDICTED_MINUS_ACTUAL: {
                        row.addCell("perc-PmA-" + i).setContentAsString("Percentile-PmA-" + this.m_Percentiles[i]);
                        continue block23;
                    }
                    case ABSOLUTE: {
                        row.addCell("perc-Abs-" + i).setContentAsString("Percentile-Abs-" + this.m_Percentiles[i]);
                        continue block23;
                    }
                    case BOTH: {
                        row.addCell("perc-AmP-" + i).setContentAsString("Percentile-AmP-" + this.m_Percentiles[i]);
                        row.addCell("perc-PmA-" + i).setContentAsString("Percentile-PmA-" + this.m_Percentiles[i]);
                        continue block23;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled error calculation: " + (Object)((Object)this.m_ErrorCalculation));
                    }
                }
            }
            ArrayList preds = evalAll.predictions();
            Random random = new Random(this.m_Seed);
            TIntArrayList indices = new TIntArrayList();
            int size = (int)Math.round((double)preds.size() * this.m_Percentage);
            Instances header = evalAll.getHeader();
            boolean numeric = header.classAttribute().isNumeric();
            this.m_ClassIndex.setData(header.classAttribute());
            int classIndex = numeric ? -1 : this.m_ClassIndex.getIntIndex();
            for (i = 0; i < preds.size(); ++i) {
                indices.add(i);
            }
            TIntArrayList subset = new TIntArrayList();
            for (int iteration = 0; iteration < this.m_NumSubSamples; ++iteration) {
                Evaluation eval;
                if (this.isStopped()) {
                    sheet = null;
                    break;
                }
                subset.clear();
                if (this.m_WithReplacement) {
                    for (i = 0; i < size; ++i) {
                        subset.add(indices.get(random.nextInt(preds.size())));
                    }
                } else {
                    indices.shuffle(random);
                    for (i = 0; i < size; ++i) {
                        subset.add(indices.get(i));
                    }
                }
                Comparable[] errors = new Double[size];
                Comparable[] errorsRev = new Double[size];
                ArrayList<Attribute> atts = new ArrayList<Attribute>();
                atts.add(header.classAttribute().copy("Actual"));
                Instances data = new Instances(header.relationName() + "-" + (iteration + 1), atts, size);
                data.setClassIndex(0);
                block28: for (i = 0; i < subset.size(); ++i) {
                    DenseInstance inst = new DenseInstance(((Prediction)preds.get(subset.get(i))).weight(), new double[]{((Prediction)preds.get(subset.get(i))).actual()});
                    data.add((Instance)inst);
                    switch (this.m_ErrorCalculation) {
                        case ACTUAL_MINUS_PREDICTED: {
                            errors[i] = Double.valueOf(((Prediction)preds.get(subset.get(i))).actual() - ((Prediction)preds.get(subset.get(i))).predicted());
                            continue block28;
                        }
                        case PREDICTED_MINUS_ACTUAL: {
                            errorsRev[i] = ((Prediction)preds.get(subset.get(i))).predicted() - ((Prediction)preds.get(subset.get(i))).actual();
                            continue block28;
                        }
                        case ABSOLUTE: {
                            errors[i] = Double.valueOf(Math.abs(((Prediction)preds.get(subset.get(i))).actual() - ((Prediction)preds.get(subset.get(i))).predicted()));
                            continue block28;
                        }
                        case BOTH: {
                            errors[i] = Double.valueOf(((Prediction)preds.get(subset.get(i))).actual() - ((Prediction)preds.get(subset.get(i))).predicted());
                            errorsRev[i] = Double.valueOf(((Prediction)preds.get(subset.get(i))).predicted() - ((Prediction)preds.get(subset.get(i))).actual());
                            continue block28;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled error calculation: " + (Object)((Object)this.m_ErrorCalculation));
                        }
                    }
                }
                try {
                    eval = new Evaluation(data);
                    for (i = 0; i < subset.size(); ++i) {
                        if (numeric) {
                            eval.evaluateModelOnceAndRecordPrediction(new double[]{((Prediction)preds.get(subset.get(i))).predicted()}, data.instance(i));
                            continue;
                        }
                        eval.evaluateModelOnceAndRecordPrediction((double[])((NominalPrediction)preds.get(subset.get(i))).distribution().clone(), data.instance(i));
                    }
                }
                catch (Exception e) {
                    result = this.handleException("Failed to create 'fake' Evaluation object (iteration: " + (iteration + 1) + ")!", e);
                    break;
                }
                row = sheet.addRow();
                row.addCell("S").setContent(Integer.valueOf(iteration + 1));
                for (EvaluationStatistic s : this.m_StatisticValues) {
                    try {
                        row.addCell(s.toString()).setContent(Double.valueOf(EvaluationHelper.getValue(eval, s, classIndex)));
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, "Failed to calculate statistic in iteration #" + (iteration + 1) + ": " + (Object)((Object)s), (Throwable)e);
                        row.addCell(s.toString()).setMissing();
                    }
                }
                block31: for (i = 0; i < this.m_Percentiles.length; ++i) {
                    Percentile perc = new Percentile();
                    perc.addAll(errors);
                    Percentile percRev = new Percentile();
                    percRev.addAll(errorsRev);
                    switch (this.m_ErrorCalculation) {
                        case ACTUAL_MINUS_PREDICTED: {
                            row.addCell("perc-AmP-" + i).setContent((Double)perc.getPercentile(this.m_Percentiles[i].doubleValue()));
                            continue block31;
                        }
                        case PREDICTED_MINUS_ACTUAL: {
                            row.addCell("perc-PmA-" + i).setContent((Double)percRev.getPercentile(this.m_Percentiles[i].doubleValue()));
                            continue block31;
                        }
                        case ABSOLUTE: {
                            row.addCell("perc-Abs-" + i).setContent((Double)perc.getPercentile(this.m_Percentiles[i].doubleValue()));
                            continue block31;
                        }
                        case BOTH: {
                            row.addCell("perc-AmP-" + i).setContent((Double)perc.getPercentile(this.m_Percentiles[i].doubleValue()));
                            row.addCell("perc-PmA-" + i).setContent((Double)percRev.getPercentile(this.m_Percentiles[i].doubleValue()));
                            continue block31;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled error calculation: " + (Object)((Object)this.m_ErrorCalculation));
                        }
                    }
                }
            }
            if (result == null && sheet != null) {
                this.m_OutputToken = new Token((Object)sheet);
            }
        }
        return result;
    }

    public static enum ErrorCalculation {
        ACTUAL_MINUS_PREDICTED,
        PREDICTED_MINUS_ACTUAL,
        BOTH,
        ABSOLUTE;

    }
}

