/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.WekaPredictionsToSpreadSheet;
import weka.classifiers.AggregateEvaluations;
import weka.classifiers.Evaluation;

public class WekaSpreadSheetToPredictions
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = -2097531874480331676L;
    protected SpreadSheetColumnIndex m_Actual;
    protected SpreadSheetColumnIndex m_Predicted;
    protected SpreadSheetColumnRange m_ClassDistribution;
    protected boolean m_UseColumnNamesAsClassLabels;
    protected SpreadSheetColumnIndex m_Weight;

    public String globalInfo() {
        return "Turns the predictions stored in the incoming spreadsheet (actual and predicted) into a Weka " + Evaluation.class.getName() + " object.\nFor recreating the predictions of a nominal class, the class distributions must be present in the spreadsheet as well.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{WekaPredictionsToSpreadSheet.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual", "actual", (Object)new SpreadSheetColumnIndex("Actual"));
        this.m_OptionManager.add("predicted", "predicted", (Object)new SpreadSheetColumnIndex("Predicted"));
        this.m_OptionManager.add("class-distribution", "classDistribution", (Object)new SpreadSheetColumnRange(""));
        this.m_OptionManager.add("column-names-as-class-labels", "useColumnNamesAsClassLabels", (Object)false);
        this.m_OptionManager.add("weight", "weight", (Object)new SpreadSheetColumnIndex(""));
    }

    public void setActual(SpreadSheetColumnIndex value) {
        this.m_Actual = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getActual() {
        return this.m_Actual;
    }

    public String actualTipText() {
        return "The column with the actual values.";
    }

    public void setPredicted(SpreadSheetColumnIndex value) {
        this.m_Predicted = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPredicted() {
        return this.m_Predicted;
    }

    public String predictedTipText() {
        return "The column with the predicted values.";
    }

    public void setClassDistribution(SpreadSheetColumnRange value) {
        this.m_ClassDistribution = value;
        this.reset();
    }

    public SpreadSheetColumnRange getClassDistribution() {
        return this.m_ClassDistribution;
    }

    public String classDistributionTipText() {
        return "The columns containing the class distribution (nominal class).";
    }

    public void setUseColumnNamesAsClassLabels(boolean value) {
        this.m_UseColumnNamesAsClassLabels = value;
        this.reset();
    }

    public boolean getUseColumnNamesAsClassLabels() {
        return this.m_UseColumnNamesAsClassLabels;
    }

    public String useColumnNamesAsClassLabelsTipText() {
        return "If enabled, the names of the class distribution columns are used as labels in the fake evaluation; automatically removes the surrounding 'Distribution (...)'.";
    }

    public void setWeight(SpreadSheetColumnIndex value) {
        this.m_Weight = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getWeight() {
        return this.m_Weight;
    }

    public String weightTipText() {
        return "The (optional) column with the weights of the instances; 1.0 is assumed by default.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"actual", (Object)this.m_Actual, (String)"actual: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"predicted", (Object)this.m_Predicted, (String)", predicted: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classDistribution", (Object)(this.m_ClassDistribution.isEmpty() ? "-none-" : this.m_ClassDistribution.getRange()), (String)", class: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"weight", (Object)(this.m_Weight.isEmpty() ? "-none-" : this.m_Weight.getIndex()), (String)", weight: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{Evaluation.class};
    }

    protected String doExecute() {
        AggregateEvaluations aggregate;
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Actual.setData((Object)sheet);
        this.m_Predicted.setData((Object)sheet);
        this.m_ClassDistribution.setData((Object)sheet);
        this.m_Weight.setData((Object)sheet);
        if (this.m_Actual.getIntIndex() == -1) {
            result = "'Actual' column not found: " + this.m_Actual;
        } else if (this.m_Predicted.getIntIndex() == -1) {
            result = "'Predicted' column not found: " + this.m_Predicted;
        }
        if (result == null && (result = (aggregate = new AggregateEvaluations()).add(sheet, this.m_Actual.getIntIndex(), this.m_Predicted.getIntIndex(), this.m_Weight.getIntIndex(), this.m_ClassDistribution.getIntIndices(), this.m_UseColumnNamesAsClassLabels)) == null) {
            Evaluation agg = aggregate.aggregated();
            if (agg == null) {
                result = aggregate.hasLastError() ? aggregate.getLastError() : "Failed to aggregate predictions!";
            }
            if (agg != null) {
                this.m_OutputToken = new Token((Object)agg);
            }
        }
        return result;
    }
}

