/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaClusterEvaluationContainer;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractCallableWekaClustererEvaluator;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Instances;

public class WekaTrainTestSetClustererEvaluator
extends AbstractCallableWekaClustererEvaluator {
    private static final long serialVersionUID = -1092101024095887007L;
    protected boolean m_OutputModel;

    public String globalInfo() {
        return "Trains a clusterer on an incoming training dataset (from a container) and then evaluates it on the test set (also from a container).\nThe clusterer setup being used in the evaluation is a callable 'Clusterer' actor.\nIf a class attribute is set, a classes-to-clusters evaluation is performed automatically";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-model", "outputModel", (Object)false);
    }

    @Override
    public String clustererTipText() {
        return "The callable clusterer actor to train and evaluate on the test data.";
    }

    public void setOutputModel(boolean value) {
        this.m_OutputModel = value;
        this.reset();
    }

    public boolean getOutputModel() {
        return this.m_OutputModel;
    }

    public String outputModelTipText() {
        return "If enabled, the clusterer model is output as well.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputModel", (boolean)this.m_OutputModel, (String)"output model", (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{WekaTrainTestSetContainer.class};
    }

    public Class[] generates() {
        return new Class[]{WekaClusterEvaluationContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Clusterer cls = this.getClustererInstance();
            if (cls == null) {
                throw new IllegalStateException("Clusterer '" + this.getClusterer() + "' not found!");
            }
            WekaTrainTestSetContainer cont = (WekaTrainTestSetContainer)((Object)this.m_InputToken.getPayload());
            Instances train = (Instances)cont.getValue("Train");
            Instances test = (Instances)cont.getValue("Test");
            cls.buildClusterer(train);
            ClusterEvaluation eval = new ClusterEvaluation();
            eval.setClusterer(cls);
            eval.evaluateClusterer(test, null, this.m_OutputModel);
            this.m_OutputToken = new Token((Object)new WekaClusterEvaluationContainer(eval, cls));
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to evaluate: ", e);
        }
        return result;
    }
}

