/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionUtils;
import adams.data.DecimalFormatString;
import adams.data.container.DataPoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.event.GeneticFitnessChangeEvent;
import adams.event.GeneticFitnessChangeListener;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractBasicMenuItemDefinition;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.core.BaseButton;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.CirclePaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.wizard.AbstractWizardPage;
import adams.gui.wizard.FinalPage;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.PropertySheetPanelPage;
import adams.gui.wizard.StartPage;
import adams.gui.wizard.WekaSelectMultipleDatasetsPage;
import adams.gui.wizard.WizardPane;
import adams.opt.genetic.AbstractClassifierBasedGeneticAlgorithm;
import adams.opt.genetic.OutputPrefixType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public abstract class AbstractClassifierBasedGeneticAlgorithmWizard
extends AbstractBasicMenuItemDefinition {
    private static final long serialVersionUID = 7586443345167287461L;
    protected AbstractClassifierBasedGeneticAlgorithm m_Current;

    public AbstractClassifierBasedGeneticAlgorithmWizard() {
        this(null);
    }

    public AbstractClassifierBasedGeneticAlgorithmWizard(AbstractApplicationFrame owner) {
        super(owner);
    }

    public String getIconName() {
        return "genetic.png";
    }

    protected abstract AbstractClassifierBasedGeneticAlgorithm getSetup();

    public AbstractClassifierBasedGeneticAlgorithm getCurrent() {
        return this.m_Current;
    }

    protected abstract StartPage getStartPage();

    public void launch() {
        final WizardPane wizard = new WizardPane();
        wizard.setCustomFinishText("Execute");
        wizard.addPage((AbstractWizardPage)this.getStartPage());
        WekaSelectMultipleDatasetsPage datasets = new WekaSelectMultipleDatasetsPage("Input");
        datasets.setDescription("Select all the dataset files that you want to process, one after the other.");
        datasets.setPageCheck(new PageCheck(){

            public boolean checkPage(AbstractWizardPage page) {
                Properties props = page.getProperties();
                try {
                    String[] files = OptionUtils.splitOptions((String)props.getProperty("files"));
                    return files.length > 0;
                }
                catch (Exception e) {
                    AbstractClassifierBasedGeneticAlgorithmWizard.this.getLogger().log(Level.SEVERE, "Failed to obtain files:", (Throwable)e);
                    return false;
                }
            }
        });
        wizard.addPage((AbstractWizardPage)datasets);
        AbstractClassifierBasedGeneticAlgorithm setup = this.getSetup();
        setup.setLoggingLevel(LoggingLevel.FINE);
        setup.setOutputPrefixType(OutputPrefixType.SUPPLIED);
        setup.setNotificationInterval(10);
        PropertySheetPanelPage algorithm = new PropertySheetPanelPage("Setup");
        algorithm.setButtonPanelVisible(true);
        algorithm.setTarget((Object)setup);
        algorithm.setDescription("Configure the genetic algorithm setup.\nSelect the classifier to use for optimizing.\nThe dataset file name (without path and extension) is automatically set as the 'supplied prefix'.");
        algorithm.setPageCheck(new PageCheck(){

            public boolean checkPage(AbstractWizardPage page) {
                Properties props = page.getProperties();
                try {
                    String cmdline = props.getProperty("Commandline");
                    OptionUtils.forAnyCommandLine(AbstractClassifierBasedGeneticAlgorithm.class, (String)cmdline);
                    return true;
                }
                catch (Exception e) {
                    AbstractClassifierBasedGeneticAlgorithmWizard.this.getLogger().log(Level.SEVERE, "Failed to obtain genetic algorithm setup:", (Throwable)e);
                    return false;
                }
            }
        });
        wizard.addPage((AbstractWizardPage)algorithm);
        FinalPage finalpage = new FinalPage();
        finalpage.setLogo(null);
        finalpage.setDescription("<html><h2>Ready</h2>Please click on <b>Execute</b> to start the optimization.</html>");
        wizard.addPage((AbstractWizardPage)finalpage);
        final ChildFrame frame = this.createChildFrame((Component)wizard, GUIHelper.getDefaultDialogDimension());
        wizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!e.getActionCommand().equals("Finish")) {
                    frame.dispose();
                    return;
                }
                Properties props = wizard.getProperties(false);
                AbstractClassifierBasedGeneticAlgorithm genetic = null;
                String[] files = null;
                try {
                    String cmdline = props.getProperty("Commandline");
                    genetic = (AbstractClassifierBasedGeneticAlgorithm)((Object)OptionUtils.forAnyCommandLine(AbstractClassifierBasedGeneticAlgorithm.class, (String)cmdline));
                    files = OptionUtils.splitOptions((String)props.getProperty("files"));
                }
                catch (Exception ex) {
                    GUIHelper.showErrorMessage(null, (String)("Failed to obtain genetic algorithm setup from wizard!\n" + LoggingHelper.throwableToString((Throwable)ex)));
                    return;
                }
                AbstractClassifierBasedGeneticAlgorithmWizard.this.doOptimize(frame, genetic, files);
            }
        });
    }

    protected void doOptimize(ChildFrame frame, final AbstractClassifierBasedGeneticAlgorithm genetic, final String[] files) {
        frame.dispose();
        JPanel panelAll = new JPanel(new BorderLayout());
        final PerformancePlot plot = new PerformancePlot(this.getTitle(), genetic);
        panelAll.add((Component)((Object)plot), "Center");
        final BaseButton buttonPause = new BaseButton((Icon)GUIHelper.getIcon((String)"pause.gif"));
        final BaseButton buttonResume = new BaseButton((Icon)GUIHelper.getIcon((String)"resume.gif"));
        final BaseButton buttonStop = new BaseButton((Icon)GUIHelper.getIcon((String)"stop_blue.gif"));
        buttonPause.setEnabled(true);
        buttonResume.setEnabled(false);
        buttonStop.setEnabled(true);
        buttonPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractClassifierBasedGeneticAlgorithmWizard.this.getCurrent().pauseExecution();
                buttonPause.setEnabled(!AbstractClassifierBasedGeneticAlgorithmWizard.this.getCurrent().isPaused());
                buttonResume.setEnabled(AbstractClassifierBasedGeneticAlgorithmWizard.this.getCurrent().isPaused());
            }
        });
        buttonResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractClassifierBasedGeneticAlgorithmWizard.this.getCurrent().resumeExecution();
                buttonPause.setEnabled(!AbstractClassifierBasedGeneticAlgorithmWizard.this.getCurrent().isPaused());
                buttonResume.setEnabled(AbstractClassifierBasedGeneticAlgorithmWizard.this.getCurrent().isPaused());
            }
        });
        buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractClassifierBasedGeneticAlgorithmWizard.this.getCurrent().stopExecution();
                buttonPause.setEnabled(false);
                buttonResume.setEnabled(false);
                buttonStop.setEnabled(false);
            }
        });
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        panelButtons.add((Component)buttonPause);
        panelButtons.add((Component)buttonResume);
        panelButtons.add((Component)buttonStop);
        this.createChildFrame(panelAll, new Dimension(GUIHelper.getDefaultDialogDimension().width, GUIHelper.getDefaultDialogDimension().height / 2));
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                for (String file : files) {
                    Instances data = ConverterUtils.DataSource.read((String)file);
                    AbstractClassifierBasedGeneticAlgorithmWizard.this.m_Current = (AbstractClassifierBasedGeneticAlgorithm)genetic.shallowCopy();
                    plot.setOwner(AbstractClassifierBasedGeneticAlgorithmWizard.this.m_Current);
                    AbstractClassifierBasedGeneticAlgorithmWizard.this.m_Current.setSuppliedPrefix(FileUtils.replaceExtension((String)new File(file).getName(), (String)""));
                    AbstractClassifierBasedGeneticAlgorithmWizard.this.m_Current.setInstances(data);
                    AbstractClassifierBasedGeneticAlgorithmWizard.this.m_Current.run();
                    if (AbstractClassifierBasedGeneticAlgorithmWizard.this.m_Current.isStopped()) break;
                }
                return null;
            }

            @Override
            protected void done() {
                buttonPause.setEnabled(false);
                buttonResume.setEnabled(false);
                buttonStop.setEnabled(false);
                if (AbstractClassifierBasedGeneticAlgorithmWizard.this.m_Current.isStopped()) {
                    GUIHelper.showErrorMessage(null, (String)(AbstractClassifierBasedGeneticAlgorithmWizard.this.getTitle() + " stopped!"));
                } else {
                    GUIHelper.showInformationMessage(null, (String)(AbstractClassifierBasedGeneticAlgorithmWizard.this.getTitle() + " finished!"));
                }
                super.done();
            }
        };
        worker.execute();
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.EXPERT;
    }

    public String getCategory() {
        return "Machine learning";
    }

    public static class PerformancePlot
    extends SequencePlotterPanel
    implements GeneticFitnessChangeListener {
        private static final long serialVersionUID = -4899150268392572586L;
        protected AbstractClassifierBasedGeneticAlgorithm m_Owner;

        public PerformancePlot(String title, AbstractClassifierBasedGeneticAlgorithm owner) {
            super(title);
            this.setOwner(owner);
            this.setTitle(owner.getMeasure().toString());
        }

        public void setOwner(AbstractClassifierBasedGeneticAlgorithm value) {
            if (this.m_Owner != null) {
                this.m_Owner.removeFitnessChangeListener(this);
            }
            this.m_Owner = value;
            this.m_Owner.addFitnessChangeListener(this);
        }

        public AbstractClassifierBasedGeneticAlgorithm getOwner() {
            return this.m_Owner;
        }

        protected void initGUI() {
            super.initGUI();
            this.getPlot().setAxisVisibility(Axis.BOTTOM, Visibility.VISIBLE);
            AxisPanelOptions axis = this.getDefaultAxisX();
            axis.configure(this.getPlot(), Axis.BOTTOM);
            this.getPlot().setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
            axis = this.getDefaultAxisY();
            axis.configure(this.getPlot(), Axis.LEFT);
            this.setDataPaintlet((Paintlet)new CirclePaintlet());
        }

        protected AxisPanelOptions getDefaultAxisX() {
            AxisPanelOptions result = new AxisPanelOptions();
            result.setType(Type.DEFAULT);
            result.setLabel("iteration");
            result.setShowGridLines(true);
            result.setLengthTicks(4);
            result.setNthValueToShow(2);
            result.setWidth(40);
            result.setTopMargin(0.0);
            result.setBottomMargin(0.0);
            result.setCustomFormat(new DecimalFormatString("0"));
            FancyTickGenerator tick = new FancyTickGenerator();
            tick.setNumTicks(20);
            result.setTickGenerator((TickGenerator)tick);
            return result;
        }

        protected AxisPanelOptions getDefaultAxisY() {
            AxisPanelOptions result = new AxisPanelOptions();
            result.setType(Type.DEFAULT);
            result.setLabel("measure");
            result.setShowGridLines(true);
            result.setLengthTicks(4);
            result.setNthValueToShow(2);
            result.setWidth(60);
            result.setTopMargin(0.0);
            result.setBottomMargin(0.0);
            result.setCustomFormat(new DecimalFormatString("0.0"));
            FancyTickGenerator tick = new FancyTickGenerator();
            tick.setNumTicks(10);
            result.setTickGenerator((TickGenerator)tick);
            return result;
        }

        public void fitnessChanged(GeneticFitnessChangeEvent e) {
            SequencePlotSequence seq;
            AbstractClassifierBasedGeneticAlgorithm algorithm = (AbstractClassifierBasedGeneticAlgorithm)e.getGeneticAlgorithm();
            String plotName = algorithm.getMeasure().toString();
            switch (algorithm.getOutputPrefixType()) {
                case NONE: {
                    break;
                }
                case RELATION: {
                    plotName = ((AbstractClassifierBasedGeneticAlgorithm)e.getGeneticAlgorithm()).getInstances().relationName() + "-" + plotName;
                    break;
                }
                case SUPPLIED: {
                    plotName = ((AbstractClassifierBasedGeneticAlgorithm)e.getGeneticAlgorithm()).getSuppliedPrefix() + "-" + plotName;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled output prefix type: " + (Object)((Object)algorithm.getOutputPrefixType()));
                }
            }
            XYSequenceContainerManager manager = (XYSequenceContainerManager)this.getContainerManager();
            manager.startUpdate();
            if (manager.indexOf(plotName) == -1) {
                seq = new SequencePlotSequence();
                seq.setComparison(XYSequencePointComparator.Comparison.X_AND_Y);
                seq.setID(plotName);
                XYSequenceContainer cont = manager.newContainer((Comparable)seq);
                manager.add(cont);
            } else {
                XYSequenceContainer cont = (XYSequenceContainer)manager.get(manager.indexOf(plotName));
                seq = cont.getData();
            }
            SequencePlotPoint point = new SequencePlotPoint((double)(seq.size() + 1), e.getFitness());
            seq.add((DataPoint)point);
            manager.finishUpdate();
        }
    }
}

