/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.flow.core.Token;
import adams.flow.transformer.WekaInstancesAppend;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.AbstractDataContainer;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.event.ActionEvent;
import weka.core.Instances;

public class Append
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public Append() {
        this.setName("Append");
        this.setIcon("append.png");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        DataContainer[] conts = this.getSelectedData();
        Instances[] data = new Instances[conts.length];
        String msg = "";
        for (int i = 0; i < conts.length; ++i) {
            if (i > 0) {
                msg = msg + ", ";
            }
            data[i] = conts[i].getData();
            msg = msg + conts[i].getID() + "/" + conts[i].getData().relationName();
        }
        this.logMessage("Appending: " + msg);
        Token token = new Token((Object)data);
        WekaInstancesAppend append = new WekaInstancesAppend();
        msg = append.setUp();
        AbstractDataContainer cont = null;
        if (msg == null) {
            append.input(token);
            msg = append.execute();
            if (msg == null) {
                token = append.output();
                cont = new MemoryContainer((Instances)token.getPayload());
                this.getData().add(cont);
                this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 2, this.getData().size() - 1));
            }
        }
        append.destroy();
        if (msg != null) {
            this.logError(msg, "Failed to append datasets");
        } else {
            this.logMessage("Appended datasets successfully into " + cont.getID());
        }
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() > 1);
    }
}

