/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.datatable.action;

import adams.gui.core.BaseCheckBox;
import adams.gui.core.CheckedTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.data.MemoryContainer;
import adams.gui.tools.wekainvestigator.datatable.action.AbstractEditableDataTableAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.supervised.instance.Resample;

public class RandomSubset
extends AbstractEditableDataTableAction {
    private static final long serialVersionUID = -8374323161691034031L;

    public RandomSubset() {
        this.setName("Random subset");
        this.setIcon("spreadsheet_subset_rows.gif");
        this.setAsynchronous(true);
    }

    protected void doActionPerformed(ActionEvent e) {
        MemoryContainer newCont;
        Resample filter;
        NumberTextField textBias;
        BaseCheckBox checkboxSupervised;
        DataContainer cont = this.getSelectedData()[0];
        ParameterPanel params = new ParameterPanel();
        NumberTextField textSeed = new NumberTextField(NumberTextField.Type.INTEGER);
        textSeed.setValue((Number)1);
        textSeed.setToolTipText("The seed value to use for randomizing the data");
        params.addParameter("Seed", (Component)textSeed);
        NumberTextField textPercentage = new NumberTextField(NumberTextField.Type.DOUBLE);
        textPercentage.setValue((Number)66.0);
        textPercentage.setToolTipText("The size of the subset (0;100)");
        params.addParameter("Percentage", (Component)textPercentage);
        BaseCheckBox checkboxReplacement = new BaseCheckBox();
        checkboxReplacement.setToolTipText("Whether to allow instances being drawn multiple times");
        params.addParameter("With replacement", (Component)checkboxReplacement);
        if (cont.getData().classIndex() > -1 && cont.getData().classAttribute().isNominal()) {
            checkboxSupervised = new BaseCheckBox();
            checkboxSupervised.setToolTipText("Whether to take the class distribution into account");
            params.addParameter("Supervised?", (Component)checkboxSupervised);
            textBias = new NumberTextField(NumberTextField.Type.DOUBLE);
            textBias.setValue((Number)0.0);
            textBias.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.DOUBLE, (Number)0.0, (Number)1.0));
            textBias.setToolTipText("Bias towards uniform class distribution: 0 = as in data, 1 = uniform");
            params.addParameter("Bias (if supervised)", (Component)textBias);
        } else {
            checkboxSupervised = null;
            textBias = null;
        }
        ApprovalDialog dialog = GUIHelper.getParentDialog((Container)((Object)this.getOwner())) != null ? new ApprovalDialog(GUIHelper.getParentDialog((Container)((Object)this.getOwner())), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(GUIHelper.getParentFrame((Container)((Object)this.getOwner())), true);
        dialog.setTitle("Random subset");
        dialog.getContentPane().add((Component)params, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this.getOwner().getOwner()));
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        int seed = textSeed.getValue().intValue();
        double percentage = textPercentage.getValue().doubleValue();
        boolean replacement = checkboxReplacement.isSelected();
        boolean supervised = checkboxSupervised != null && checkboxSupervised.isSelected();
        double bias = supervised ? textBias.getValue().doubleValue() : 0.0;
        this.logMessage("Generating subset: " + cont.getID() + "/" + cont.getData().relationName() + " [" + cont.getSource() + "]");
        if (supervised) {
            filter = new Resample();
            filter.setRandomSeed(seed);
            filter.setSampleSizePercent(percentage);
            filter.setNoReplacement(!replacement);
            filter.setBiasToUniformClass(bias);
        } else {
            filter = new weka.filters.unsupervised.instance.Resample();
            ((weka.filters.unsupervised.instance.Resample)filter).setRandomSeed(seed);
            ((weka.filters.unsupervised.instance.Resample)filter).setSampleSizePercent(percentage);
            ((weka.filters.unsupervised.instance.Resample)filter).setNoReplacement(!replacement);
        }
        try {
            filter.setInputFormat(cont.getData());
            newCont = new MemoryContainer(Filter.useFilter((Instances)cont.getData(), (Filter)filter));
        }
        catch (Exception ex) {
            GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)"Failed to generate subset!", (Throwable)ex);
            return;
        }
        this.getData().add(newCont);
        this.logMessage("Successfully generated subset from " + cont.getID() + ": " + newCont.getID() + "!");
        this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 2, this.getData().size() - 1));
    }

    @Override
    public void update() {
        this.setEnabled(!this.isBusy() && this.getTable().getSelectedRowCount() == 1);
    }
}

