/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.history;

import adams.core.ClassLister;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.ConsolePanel;
import adams.gui.tools.wekainvestigator.history.MenuItemComparator;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractHistoryPopupMenuItem<H extends AbstractNamedHistoryPanel, T extends AbstractInvestigatorTab> {
    protected T m_Owner;

    public void setOwner(T value) {
        this.m_Owner = value;
    }

    public T getOwner() {
        return this.m_Owner;
    }

    public abstract String getCategory();

    public abstract String getTitle();

    public abstract JMenuItem createMenuItem(H var1, int[] var2);

    public static void updatePopupMenu(AbstractNamedHistoryPanel history, AbstractInvestigatorTab owner, int[] indices, JPopupMenu menu, Class superclass) {
        Class[] classes = ClassLister.getSingleton().getClasses(superclass);
        ArrayList<AbstractHistoryPopupMenuItem> menuitems = new ArrayList<AbstractHistoryPopupMenuItem>();
        for (Class cls : classes) {
            try {
                menuitems.add((AbstractHistoryPopupMenuItem)cls.newInstance());
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate menu item class: " + cls.getName(), (Throwable)e);
            }
        }
        Collections.sort(menuitems, new MenuItemComparator());
        String category = "";
        for (AbstractHistoryPopupMenuItem menuitem : menuitems) {
            if (!menuitem.getCategory().equals(category)) {
                menu.addSeparator();
            }
            menuitem.setOwner(owner);
            category = menuitem.getCategory();
            JMenuItem item = menuitem.createMenuItem(history, indices);
            if (item == null) continue;
            menu.add(item);
        }
    }
}

