/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.Index;
import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.Range;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.weka.WekaAttributeRange;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.BaseTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabJob;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.Coordinates;
import adams.gui.visualization.stats.scatterplot.ScatterPlot;
import adams.gui.visualization.stats.scatterplot.action.MouseClickAction;
import adams.gui.visualization.stats.scatterplot.action.ViewDataClickAction;
import com.github.waikatodatamining.matrix.algorithm.ica.FastICA;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.core.Instances;

public class IndependentComponentsTab
extends AbstractInvestigatorTab {
    private static final long serialVersionUID = -4106630131554796889L;
    public static final String KEY_LEFTPANELWIDTH = "leftpanelwidth";
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_RANGE = "range";
    public static final String KEY_ICA = "ica";
    public static final String KEY_ADDITIONALATTRIBUTES = "additional attributes";
    protected BaseSplitPane m_SplitPane;
    protected JPanel m_PanelLeft;
    protected JPanel m_PanelRight;
    protected ParameterPanel m_PanelParameters;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected BaseTextField m_TextAttributeRange;
    protected GenericObjectEditorPanel m_PanelICA;
    protected BaseTextField m_TextAdditionalAttributes;
    protected BaseButton m_ButtonStart;
    protected BaseButton m_ButtonStop;
    protected BaseTabbedPane m_TabbedPanePlots;
    protected ScatterPlot m_PanelComponents;
    protected ScatterPlot m_PanelSources;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ModelDatasets = new DefaultComboBoxModel();
    }

    protected void initGUI() {
        FastICA fastica;
        super.initGUI();
        Properties props = InvestigatorPanel.getProperties();
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setDividerLocation(props.getInteger("IndependentComponents.LeftPanelWidth", Integer.valueOf(200)).intValue());
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_ContentPanel.add((Component)this.m_SplitPane, (Object)"Center");
        this.m_PanelLeft = new JPanel(new BorderLayout());
        this.m_PanelRight = new JPanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent((Component)this.m_PanelLeft);
        this.m_SplitPane.setRightComponent((Component)this.m_PanelRight);
        JPanel panelOptions = new JPanel(new BorderLayout());
        this.m_PanelLeft.add((Component)panelOptions, "North");
        this.m_PanelParameters = new ParameterPanel();
        panelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_TextAttributeRange = new BaseTextField(20);
        this.m_TextAttributeRange.setText("first-last");
        this.m_TextAttributeRange.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IndependentComponentsTab.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IndependentComponentsTab.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IndependentComponentsTab.this.updateButtons();
            }
        });
        this.m_PanelParameters.addParameter("Range", (Component)this.m_TextAttributeRange);
        try {
            fastica = (FastICA)OptionUtils.forAnyCommandLine(FastICA.class, (String)props.getProperty("IndependentComponents.FastICA", OptionUtils.getCommandLine((Object)new FastICA())));
        }
        catch (Exception e2) {
            fastica = new FastICA();
        }
        this.m_PanelICA = new GenericObjectEditorPanel(FastICA.class, (Object)fastica);
        this.m_PanelICA.addChangeListener(e -> this.updateButtons());
        this.m_PanelParameters.addParameter("ICA", (Component)this.m_PanelICA);
        this.m_TextAdditionalAttributes = new BaseTextField(20);
        this.m_TextAdditionalAttributes.setText("");
        this.m_TextAdditionalAttributes.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IndependentComponentsTab.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IndependentComponentsTab.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IndependentComponentsTab.this.updateButtons();
            }
        });
        this.m_PanelParameters.addParameter("Additional attributes", (Component)this.m_TextAdditionalAttributes);
        JPanel panelButtons = new JPanel(new FlowLayout(0));
        panelOptions.add((Component)panelButtons, "South");
        this.m_ButtonStart = new BaseButton("Start");
        this.m_ButtonStart.addActionListener(e -> this.startExecution());
        panelButtons.add((Component)this.m_ButtonStart);
        this.m_ButtonStop = new BaseButton("Stop");
        this.m_ButtonStop.addActionListener(e -> this.stopExecution());
        panelButtons.add((Component)this.m_ButtonStop);
        this.m_TabbedPanePlots = new BaseTabbedPane();
        this.m_PanelRight.add((Component)this.m_TabbedPanePlots, "Center");
        this.m_PanelComponents = new ScatterPlot();
        this.m_PanelComponents.setXIndex(new Index("1"));
        this.m_PanelComponents.setYIndex(new Index("2"));
        this.m_PanelComponents.getPlot().getAxis(Axis.LEFT).setTopMargin(0.01);
        this.m_PanelComponents.getPlot().getAxis(Axis.LEFT).setBottomMargin(0.01);
        this.m_PanelComponents.getPlot().getAxis(Axis.BOTTOM).setTopMargin(0.01);
        this.m_PanelComponents.getPlot().getAxis(Axis.BOTTOM).setBottomMargin(0.01);
        this.m_PanelComponents.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        this.m_PanelComponents.setOverlays(new AbstractScatterPlotOverlay[]{new Coordinates()});
        this.m_TabbedPanePlots.addTab("Components", (Component)this.m_PanelComponents);
        this.m_PanelSources = new ScatterPlot();
        this.m_PanelSources.setXIndex(new Index("1"));
        this.m_PanelSources.setYIndex(new Index("2"));
        this.m_PanelSources.getPlot().getAxis(Axis.LEFT).setTopMargin(0.01);
        this.m_PanelSources.getPlot().getAxis(Axis.LEFT).setBottomMargin(0.01);
        this.m_PanelSources.getPlot().getAxis(Axis.BOTTOM).setTopMargin(0.01);
        this.m_PanelSources.getPlot().getAxis(Axis.BOTTOM).setBottomMargin(0.01);
        this.m_PanelSources.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        this.m_PanelSources.setOverlays(new AbstractScatterPlotOverlay[]{new Coordinates()});
        this.m_TabbedPanePlots.addTab("Sources", (Component)this.m_PanelSources);
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    @Override
    public String getTitle() {
        return "ICA";
    }

    @Override
    public String getTabIcon() {
        return "scatterplot.gif";
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        if (e.getType() == 5) {
            this.m_ComboBoxDatasets.setSelectedIndex(e.getRows()[0]);
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(this.getData());
        int index = DatasetHelper.indexOfDataset(this.getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[0]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        this.updateButtons();
    }

    @Override
    public boolean isBusy() {
        return this.m_Worker != null;
    }

    protected String canVisualize() {
        String rangeStr = this.m_TextAttributeRange.getText();
        String additionalStr = this.m_TextAdditionalAttributes.getText();
        Instances data = this.m_ComboBoxDatasets.getSelectedIndex() > -1 ? this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData() : null;
        if (this.isBusy()) {
            return "Currently busy...";
        }
        if (data == null) {
            return "No data selected!";
        }
        if (rangeStr.isEmpty()) {
            return "No attribute range provided!";
        }
        if (!Range.isValid((String)rangeStr, (int)data.numAttributes())) {
            return "Invalid attribute range!";
        }
        if (!additionalStr.isEmpty() && !Range.isValid((String)rangeStr, (int)data.numAttributes())) {
            return "Invalid additional attributes range!";
        }
        return null;
    }

    protected void updateButtons() {
        String msg = this.canVisualize();
        this.m_ButtonStart.setEnabled(msg == null);
        this.m_ButtonStart.setToolTipText(msg);
        this.m_ButtonStop.setEnabled(this.isBusy());
    }

    protected int[] getAdditionalAttributeIndices(Instances data) {
        int[] result;
        if (!this.m_TextAdditionalAttributes.getText().isEmpty()) {
            WekaAttributeRange addRange = new WekaAttributeRange(this.m_TextAdditionalAttributes.getText());
            addRange.setData(data);
            result = addRange.getIntIndices();
        } else {
            result = new int[]{};
        }
        return result;
    }

    protected void addAdditionalAttributes(SpreadSheet sheet, Instances data, int[] additional) {
        int a;
        if (additional.length == 0) {
            return;
        }
        if (sheet.getRowCount() != data.numInstances()) {
            this.logError("Failed to transfer additional attributes, number of rows in data differ: " + sheet.getRowCount() + " != " + data.numInstances() + "\nDataset: " + data.relationName(), this.getTitle() + " - Additional attributes transfer");
            return;
        }
        int[] newIndices = new int[additional.length];
        for (a = 0; a < additional.length; ++a) {
            newIndices[a] = sheet.getColumnCount();
            sheet.insertColumn(sheet.getColumnCount(), data.attribute(additional[a]).name());
        }
        for (int r = 0; r < sheet.getRowCount(); ++r) {
            for (a = 0; a < additional.length; ++a) {
                if (data.attribute(additional[a]).isNumeric()) {
                    sheet.getCell(r, newIndices[a]).setContent(Double.valueOf(data.instance(r).value(additional[a])));
                    continue;
                }
                if (!data.attribute(additional[a]).isNominal() && !data.attribute(additional[a]).isString()) continue;
                sheet.getCell(r, newIndices[a]).setContent(data.instance(r).stringValue(additional[a]));
            }
        }
    }

    protected void startExecution() {
        this.startExecution(new InvestigatorTabJob(this, "ICA visualization"){

            @Override
            protected void doRun() {
                DataContainer cont = IndependentComponentsTab.this.getData().get(IndependentComponentsTab.this.m_ComboBoxDatasets.getSelectedIndex());
                Instances data = cont.getData();
                adams.data.instancesanalysis.FastICA fastica = new adams.data.instancesanalysis.FastICA();
                fastica.setICA((FastICA)IndependentComponentsTab.this.m_PanelICA.getCurrent());
                fastica.setAttributeRange(new WekaAttributeRange(IndependentComponentsTab.this.m_TextAttributeRange.getText()));
                String msg = fastica.analyze(data);
                if (msg != null) {
                    IndependentComponentsTab.this.logError(msg, "ICA error");
                } else {
                    int[] additional = IndependentComponentsTab.this.getAdditionalAttributeIndices(data);
                    SpreadSheet components = fastica.getComponents().getClone();
                    IndependentComponentsTab.this.m_PanelComponents.setData(components);
                    IndependentComponentsTab.this.m_PanelComponents.reset();
                    SpreadSheet sources = fastica.getSources().getClone();
                    IndependentComponentsTab.this.addAdditionalAttributes(sources, data, additional);
                    IndependentComponentsTab.this.m_PanelSources.setData(sources);
                    IndependentComponentsTab.this.m_PanelSources.reset();
                }
            }
        });
    }

    @Override
    protected void postStartExecution(InvestigatorTabJob job) {
        super.postStartExecution(job);
        this.updateButtons();
    }

    @Override
    protected void postStopExecution() {
        super.postStopExecution();
        this.logMessage("Stopped ICA visualization");
        this.updateButtons();
    }

    @Override
    protected void postExecutionFinished() {
        super.postExecutionFinished();
        this.updateButtons();
    }

    @Override
    protected Map<String, Object> doSerialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.doSerialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_LEFTPANELWIDTH, this.m_SplitPane.getDividerLocation());
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_RANGE, this.m_TextAttributeRange.getText());
            result.put(KEY_ICA, this.m_PanelICA.getCurrent());
            result.put(KEY_ADDITIONALATTRIBUTES, this.m_TextAdditionalAttributes.getText());
        }
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_LEFTPANELWIDTH)) {
            this.m_SplitPane.setDividerLocation(((Number)data.get(KEY_LEFTPANELWIDTH)).intValue());
        }
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
        if (data.containsKey(KEY_RANGE)) {
            this.m_TextAttributeRange.setText((String)data.get(KEY_RANGE));
        }
        if (data.containsKey(KEY_ICA)) {
            this.m_PanelICA.setCurrent(data.get(KEY_ICA));
        }
        if (data.containsKey(KEY_ADDITIONALATTRIBUTES)) {
            this.m_TextAdditionalAttributes.setText((String)data.get(KEY_ADDITIONALATTRIBUTES));
        }
    }
}

