/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.Range;
import adams.core.option.OptionUtils;
import adams.data.instance.Instance;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ParameterPanel;
import adams.gui.core.RangeTextField;
import adams.gui.core.SearchPanel;
import adams.gui.core.SearchableBaseList;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.PaintletWithMarkers;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.core.Instances;

public class InstanceTab
extends AbstractInvestigatorTab {
    private static final long serialVersionUID = -4106630131554796889L;
    public static final String KEY_LEFTPANELWIDTH = "leftpanelwidth";
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_ID = "id";
    public static final String KEY_COLOR = "color";
    public static final String KEY_COLORPROVIDER = "colorprovider";
    public static final String KEY_RANGE = "range";
    public static final String KEY_ANTIALIASING = "antialiasing";
    public static final String KEY_MARKERS = "markers";
    public static final String KEY_IDS = "ids";
    protected BaseSplitPane m_SplitPane;
    protected JPanel m_PanelLeft;
    protected JPanel m_PanelRight;
    protected ParameterPanel m_PanelParameters;
    protected DefaultComboBoxModel<String> m_ModelAttributesID;
    protected DefaultComboBoxModel<String> m_ModelAttributesColor;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected BaseComboBox<String> m_ComboBoxID;
    protected RangeTextField m_TextAttributeRange;
    protected BaseComboBox<String> m_ComboBoxColor;
    protected GenericObjectEditorPanel m_PanelColorProvider;
    protected BaseCheckBox m_CheckBoxAntiAliasing;
    protected BaseCheckBox m_CheckBoxMarkers;
    protected DefaultListModel<Comparable> m_ModelIDs;
    protected SearchableBaseList m_ListIDs;
    protected SearchPanel m_PanelSearchID;
    protected BaseButton m_ButtonVisualize;
    protected InstancePanel m_PanelInstance;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ModelAttributesID = new DefaultComboBoxModel();
        this.m_ModelAttributesColor = new DefaultComboBoxModel();
        this.m_ModelIDs = new DefaultListModel();
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = InvestigatorPanel.getProperties();
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setDividerLocation(props.getInteger("Instance.LeftPanelWidth", Integer.valueOf(200)).intValue());
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_ContentPanel.add((Component)this.m_SplitPane, (Object)"Center");
        this.m_PanelLeft = new JPanel(new BorderLayout());
        this.m_PanelRight = new JPanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent((Component)this.m_PanelLeft);
        this.m_SplitPane.setRightComponent((Component)this.m_PanelRight);
        JPanel panelOptions = new JPanel(new BorderLayout());
        this.m_PanelLeft.add((Component)panelOptions, "North");
        this.m_PanelParameters = new ParameterPanel();
        panelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.updateAttributes());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_ComboBoxID = new BaseComboBox(this.m_ModelAttributesID);
        this.m_ComboBoxID.addActionListener(e -> this.updateIDs());
        this.m_PanelParameters.addParameter("ID", this.m_ComboBoxID);
        this.m_TextAttributeRange = new RangeTextField("first-last");
        this.m_TextAttributeRange.setColumns(20);
        this.m_TextAttributeRange.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                InstanceTab.this.updateButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InstanceTab.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InstanceTab.this.updateButtons();
            }
        });
        this.m_PanelParameters.addParameter("Range", (Component)this.m_TextAttributeRange);
        this.m_ComboBoxColor = new BaseComboBox(this.m_ModelAttributesColor);
        this.m_PanelParameters.addParameter("Color", this.m_ComboBoxColor);
        this.m_PanelColorProvider = new GenericObjectEditorPanel(ColorProvider.class, (Object)new DefaultColorProvider(), true);
        this.m_PanelParameters.addParameter("Color provider", (Component)this.m_PanelColorProvider);
        this.m_CheckBoxAntiAliasing = new BaseCheckBox();
        this.m_CheckBoxAntiAliasing.setSelected(props.getBoolean("Instance.AntiAliasing", Boolean.valueOf(true)).booleanValue());
        this.m_PanelParameters.addParameter("Use anti-aliasing", (Component)this.m_CheckBoxAntiAliasing);
        this.m_CheckBoxMarkers = new BaseCheckBox();
        this.m_CheckBoxMarkers.setSelected(props.getBoolean("Instance.Markers", Boolean.valueOf(true)).booleanValue());
        this.m_PanelParameters.addParameter("Use makers", (Component)this.m_CheckBoxMarkers);
        JPanel panelIDs = new JPanel(new BorderLayout(5, 5));
        panelIDs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_PanelLeft.add((Component)panelIDs, "Center");
        this.m_ListIDs = new SearchableBaseList(this.m_ModelIDs);
        this.m_PanelSearchID = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false);
        this.m_PanelSearchID.addSearchListener(e -> this.m_ListIDs.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
        panelIDs.add((Component)new JLabel("Instances to display"), "North");
        panelIDs.add((Component)new BaseScrollPane((Component)this.m_ListIDs), "Center");
        panelIDs.add((Component)this.m_PanelSearchID, "South");
        JPanel panelButtons = new JPanel(new FlowLayout(0));
        this.m_PanelLeft.add((Component)panelButtons, "South");
        this.m_ButtonVisualize = new BaseButton("Visualize");
        this.m_ButtonVisualize.setMnemonic('V');
        this.m_ButtonVisualize.addActionListener(e -> this.visualize());
        panelButtons.add((Component)this.m_ButtonVisualize);
        this.m_PanelInstance = new InstancePanel();
        this.m_PanelInstance.setZoomOverviewPanelVisible(true);
        this.m_PanelInstance.setSidePanelVisible(false);
        this.m_PanelRight.add((Component)((Object)this.m_PanelInstance), "Center");
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    @Override
    public String getTitle() {
        return "Instance";
    }

    @Override
    public String getTabIcon() {
        return "chart.gif";
    }

    protected boolean hasDataChanged(List<String> newDatasets, ComboBoxModel<String> currentModel) {
        int index;
        boolean result;
        HashSet<String> setDatasets = new HashSet<String>(newDatasets);
        HashSet setModel = new HashSet();
        for (int i = 0; i < currentModel.getSize(); ++i) {
            setModel.add(currentModel.getElementAt(i));
        }
        boolean bl = result = setDatasets.size() != setModel.size() || !setDatasets.containsAll(setModel) || !setModel.containsAll(setDatasets);
        if (!result && (index = DatasetHelper.indexOfDataset(this.getOwner().getData(), (String)this.m_ComboBoxDatasets.getSelectedItem())) > -1 && this.getData().get(index).getData().numAttributes() != this.m_ComboBoxID.getModel().getSize() - 1) {
            result = true;
        }
        return result;
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        if (e.getType() == 5) {
            this.m_ComboBoxDatasets.setSelectedIndex(e.getRows()[0]);
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(this.getOwner().getData());
        int index = DatasetHelper.indexOfDataset(this.getOwner().getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (this.hasDataChanged(datasets, this.m_ModelDatasets) || e.getType() == 4) {
            this.m_ModelIDs.clear();
            this.m_ModelAttributesID.removeAllElements();
            this.m_ModelAttributesColor.removeAllElements();
            this.m_PanelInstance.getSequenceManager().clear();
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[0]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        this.updateButtons();
    }

    protected void updateAttributes() {
        String oldID = (String)this.m_ComboBoxID.getSelectedItem();
        String oldColor = (String)this.m_ComboBoxColor.getSelectedItem();
        this.m_ModelAttributesID.removeAllElements();
        this.m_ModelAttributesColor.removeAllElements();
        if (this.m_ComboBoxDatasets.getSelectedIndex() == -1) {
            return;
        }
        if (this.m_ComboBoxDatasets.getSelectedIndex() > this.getData().size() - 1) {
            return;
        }
        Instances data = this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ArrayList<String> atts = new ArrayList<String>();
        atts.add("-none-");
        for (int i = 0; i < data.numAttributes(); ++i) {
            atts.add(i + 1 + ": " + data.attribute(i).name());
        }
        this.m_ModelAttributesID = new DefaultComboBoxModel<String>(atts.toArray(new String[0]));
        int indexID = this.m_ModelAttributesID.getIndexOf(oldID);
        this.m_ModelAttributesColor = new DefaultComboBoxModel<String>(atts.toArray(new String[0]));
        int indexColor = this.m_ModelAttributesColor.getIndexOf(oldColor);
        this.m_ComboBoxID.setModel(this.m_ModelAttributesID);
        if (indexID == -1) {
            this.m_ComboBoxID.setSelectedIndex(0);
        } else {
            this.m_ComboBoxID.setSelectedIndex(indexID);
        }
        this.m_ComboBoxColor.setModel(this.m_ModelAttributesColor);
        if (indexColor == -1) {
            this.m_ComboBoxColor.setSelectedIndex(0);
        } else {
            this.m_ComboBoxColor.setSelectedIndex(indexColor);
        }
    }

    protected void updateIDs() {
        this.m_ModelIDs.clear();
        if (this.m_ComboBoxDatasets.getSelectedIndex() == -1) {
            return;
        }
        if (this.m_ComboBoxDatasets.getSelectedIndex() > this.getData().size() - 1) {
            return;
        }
        Instances data = this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ArrayList<Object> ids = new ArrayList<Object>();
        int indexID = this.m_ComboBoxID.getSelectedIndex() - 1;
        for (int i = 0; i < data.numInstances(); ++i) {
            if (indexID > -1) {
                weka.core.Instance inst = data.instance(i);
                if (inst.attribute(indexID).isNumeric()) {
                    ids.add(inst.value(indexID));
                    continue;
                }
                ids.add(inst.stringValue(indexID));
                continue;
            }
            ids.add(i + 1);
        }
        if (indexID > -1) {
            Collections.sort(ids);
        }
        this.m_ModelIDs = new DefaultListModel();
        for (Comparable comparable : ids) {
            this.m_ModelIDs.addElement(comparable);
        }
        this.m_ListIDs.setModel(this.m_ModelIDs);
    }

    protected String canVisualize() {
        Instances data = this.m_ComboBoxDatasets.getSelectedIndex() > -1 ? this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData() : null;
        if (data == null) {
            return "No data available!";
        }
        String rangeStr = this.m_TextAttributeRange.getText();
        if (rangeStr.isEmpty()) {
            return "No attribute range defined!";
        }
        if (!Range.isValid((String)rangeStr, (int)data.numAttributes())) {
            return "Invalid attribute range!";
        }
        return null;
    }

    protected void updateButtons() {
        String msg = this.canVisualize();
        this.m_ButtonVisualize.setEnabled(msg == null);
        this.m_ButtonVisualize.setToolTipText(msg);
    }

    protected void visualize() {
        int i;
        ColorProvider provider;
        int attColorIndex;
        HashMap<Double, Color> attColors;
        if (this.m_ComboBoxDatasets.getSelectedIndex() == -1) {
            return;
        }
        Instances data = this.getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        Range range = new Range(this.m_TextAttributeRange.getText());
        int indexID = this.m_ComboBoxID.getSelectedIndex() - 1;
        HashSet<Integer> attTypes = new HashSet<Integer>();
        attTypes.add(0);
        boolean numericID = false;
        TIntArrayList additional = new TIntArrayList();
        if (indexID > -1) {
            additional.add(indexID);
            numericID = data.attribute(indexID).isNumeric();
        }
        HashSet<Comparable> ids = null;
        int[] sel = this.m_ListIDs.getSelectedIndices();
        if (sel.length > 0) {
            ids = new HashSet<Comparable>();
            for (int s : sel) {
                ids.add(this.m_ModelIDs.get(s));
            }
        }
        if (this.m_ComboBoxColor.getSelectedIndex() > 0 && data.classIndex() > -1) {
            attColors = new HashMap<Double, Color>();
            attColorIndex = this.m_ComboBoxColor.getSelectedIndex() - 1;
            provider = (ColorProvider)this.m_PanelColorProvider.getCurrent();
            if (data.attribute(attColorIndex).isNominal()) {
                for (i = 0; i < data.attribute(attColorIndex).numValues(); ++i) {
                    attColors.put(Double.valueOf(i), provider.next());
                }
            }
        } else {
            attColors = null;
            attColorIndex = -1;
            provider = null;
        }
        InstanceContainerManager manager = (InstanceContainerManager)this.m_PanelInstance.getContainerManager();
        manager.clear();
        this.m_PanelInstance.setAntiAliasingEnabled(this.m_CheckBoxAntiAliasing.isSelected());
        if (this.m_PanelInstance.getDataPaintlet() instanceof PaintletWithMarkers) {
            ((PaintletWithMarkers)this.m_PanelInstance.getDataPaintlet()).setMarkersDisabled(!this.m_CheckBoxMarkers.isSelected());
        }
        manager.startUpdate();
        for (i = 0; i < data.numInstances(); ++i) {
            Object id;
            weka.core.Instance winst = data.instance(i);
            if (ids != null && (indexID > -1 ? !ids.contains(id = numericID ? Double.valueOf(winst.value(indexID)) : winst.stringValue(indexID)) : !ids.contains(i + 1))) continue;
            Instance ainst = new Instance();
            ainst.set(winst, i, additional.toArray(), range, attTypes);
            InstanceContainer cont = manager.newContainer((Comparable)((Object)ainst));
            if (indexID > -1) {
                if (numericID) {
                    cont.setID("" + winst.value(indexID));
                } else {
                    cont.setID(winst.stringValue(indexID));
                }
            } else {
                cont.setID("" + (i + 1));
            }
            manager.add(cont);
            if (attColors == null) continue;
            double attValue = winst.value(attColorIndex);
            if (!attColors.containsKey(attValue)) {
                Color attColor = provider.next();
                attColors.put(attValue, attColor);
            }
            cont.setColor((Color)attColors.get(attValue));
        }
        manager.finishUpdate();
    }

    @Override
    protected Map<String, Object> doSerialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.doSerialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_LEFTPANELWIDTH, this.m_SplitPane.getDividerLocation());
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
            result.put(KEY_ID, this.m_ComboBoxID.getSelectedIndex());
            result.put(KEY_COLOR, this.m_ComboBoxColor.getSelectedIndex());
            result.put(KEY_IDS, this.m_ListIDs.getSelectedIndices());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_RANGE, this.m_TextAttributeRange.getText());
            result.put(KEY_COLORPROVIDER, OptionUtils.getCommandLine((Object)this.m_PanelColorProvider.getCurrent()));
            result.put(KEY_ANTIALIASING, this.m_CheckBoxAntiAliasing.isSelected());
            result.put(KEY_MARKERS, this.m_CheckBoxMarkers.isSelected());
        }
        return result;
    }

    @Override
    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
        super.doDeserialize(data, errors);
        if (data.containsKey(KEY_LEFTPANELWIDTH)) {
            this.m_SplitPane.setDividerLocation(((Number)data.get(KEY_LEFTPANELWIDTH)).intValue());
        }
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
        if (data.containsKey(KEY_ID)) {
            this.m_ComboBoxID.setSelectedIndex(((Number)data.get(KEY_ID)).intValue());
        }
        if (data.containsKey(KEY_COLOR)) {
            this.m_ComboBoxColor.setSelectedIndex(((Number)data.get(KEY_COLOR)).intValue());
        }
        if (data.containsKey(KEY_COLORPROVIDER)) {
            try {
                this.m_PanelColorProvider.setCurrent(OptionUtils.forAnyCommandLine(ColorProvider.class, (String)((String)data.get(KEY_COLORPROVIDER))));
            }
            catch (Exception e) {
                this.m_PanelColorProvider.setCurrent((Object)new DefaultColorProvider());
            }
        }
        if (data.containsKey(KEY_RANGE)) {
            this.m_TextAttributeRange.setText((String)data.get(KEY_RANGE));
        }
        if (data.containsKey(KEY_ANTIALIASING)) {
            this.m_CheckBoxAntiAliasing.setSelected(((Boolean)data.get(KEY_ANTIALIASING)).booleanValue());
        }
        if (data.containsKey(KEY_MARKERS)) {
            this.m_CheckBoxMarkers.setSelected(((Boolean)data.get(KEY_MARKERS)).booleanValue());
        }
        if (data.containsKey(KEY_IDS)) {
            this.m_ListIDs.setSelectedIndices((int[])data.get(KEY_IDS));
        }
    }
}

