/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.attseltab;

import adams.core.DateUtils;
import adams.core.Shortening;
import adams.data.spreadsheet.MetaData;
import adams.gui.tools.wekainvestigator.output.AbstractResultItem;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.core.Instances;

public class ResultItem
extends AbstractResultItem {
    private static final long serialVersionUID = -3409493446200539772L;
    protected AttributeSelection m_AttributeSelection;
    protected ASSearch m_Search;
    protected ASEvaluation m_Evaluator;
    protected int m_Folds;
    protected Instances m_Full;
    protected MetaData m_RunInformation;

    public ResultItem(ASEvaluation evaluator, ASSearch search, Instances header) {
        super(header);
        if (evaluator == null) {
            throw new IllegalArgumentException("Evaluator cannot be null!");
        }
        if (search == null) {
            throw new IllegalArgumentException("Search cannot be null!");
        }
        this.m_Search = search;
        this.m_Evaluator = evaluator;
    }

    @Override
    protected String createName() {
        return DateUtils.getTimeFormatterMsecs().format(this.m_Timestamp) + " - " + this.m_Search.getClass().getSimpleName() + "/" + this.m_Evaluator.getClass().getSimpleName() + " - " + Shortening.shortenEnd((String)this.m_Header.relationName(), (int)30);
    }

    public void update(AttributeSelection attsel, Instances full, MetaData runInfo) {
        this.update(attsel, -1, full, runInfo);
    }

    public void update(AttributeSelection attsel, int folds, MetaData runInfo) {
        this.update(attsel, folds, null, runInfo);
    }

    protected void update(AttributeSelection attsel, int folds, Instances full, MetaData runInfo) {
        if (attsel == null) {
            throw new IllegalArgumentException("Attribute selection cannot be null!");
        }
        this.m_AttributeSelection = attsel;
        this.m_Folds = folds;
        this.m_Full = full;
        this.m_RunInformation = runInfo;
    }

    public AttributeSelection getAttributeSelection() {
        return this.m_AttributeSelection;
    }

    public ASSearch getSearch() {
        return this.m_Search;
    }

    public ASEvaluation getEvaluator() {
        return this.m_Evaluator;
    }

    public boolean isCrossValidation() {
        return this.m_Folds >= 2;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public boolean hasFull() {
        return this.m_Full != null;
    }

    public Instances getFull() {
        return this.m_Full;
    }

    public boolean hasRunInformation() {
        return this.m_RunInformation != null;
    }

    public MetaData getRunInformation() {
        return this.m_RunInformation;
    }

    @Override
    public String toString() {
        String result = this.getName();
        result = result + ", CV=" + this.isCrossValidation() + ", full=" + this.hasFull() + ", runInfo=" + this.hasRunInformation() + ", header=" + this.hasHeader();
        return result;
    }
}

