/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.attseltab.output;

import adams.core.MessageCollection;
import adams.gui.core.BaseTable;
import adams.gui.tools.wekainvestigator.output.TableContentPanel;
import adams.gui.tools.wekainvestigator.tab.attseltab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.attseltab.output.AbstractOutputGenerator;
import adams.gui.visualization.instances.InstancesTable;
import javax.swing.JComponent;
import weka.core.Instances;

public class ReducedData
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;

    public String globalInfo() {
        return "Generates the reduced dataset.";
    }

    @Override
    public String getTitle() {
        return "Reduced data";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return !item.isCrossValidation() && item.hasFull();
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        Instances reduced;
        if (!item.hasFull()) {
            errors.add("No dataset available to reduce!");
            return null;
        }
        try {
            reduced = item.getAttributeSelection().reduceDimensionality(item.getFull());
        }
        catch (Exception e) {
            errors.add("Failed to reduce data!", (Throwable)e);
            return null;
        }
        InstancesTable table = new InstancesTable(reduced);
        return new TableContentPanel((BaseTable)table, true);
    }
}

