/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.tools.wekainvestigator.output.RunInformationHelper;
import adams.gui.tools.wekainvestigator.output.TextualContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class RunInformation
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;

    public String globalInfo() {
        return "Outputs the run information.";
    }

    @Override
    public String getTitle() {
        return "Run information";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasRunInformation();
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        if (!item.hasRunInformation()) {
            errors.add("No run information available!");
            return null;
        }
        BaseTextArea text = new BaseTextArea();
        text.setEditable(false);
        text.setTextFont(Fonts.getMonospacedFont());
        text.setText(RunInformationHelper.toString(item.getRunInformation().toSpreadSheet()));
        text.setCaretPosition(0);
        return new TextualContentPanel((JTextComponent)text, true);
    }
}

