/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.clustertab.evaluation;

import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.SerializationHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.MetaData;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.evaluation.DatasetHelper;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTab;
import adams.gui.tools.wekainvestigator.tab.ClusterTab;
import adams.gui.tools.wekainvestigator.tab.clustertab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.evaluation.AbstractClustererEvaluation;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import weka.clusterers.Clusterer;
import weka.core.Capabilities;
import weka.core.Instances;

public class BuildModel
extends AbstractClustererEvaluation {
    private static final long serialVersionUID = 1175400993991698944L;
    public static final String KEY_DATASET = "dataset";
    public static final String KEY_PRESERVEORDER = "preserveorder";
    public static final String KEY_SEED = "seed";
    public static final String KEY_MODEL = "model";
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<String> m_ComboBoxDatasets;
    protected BaseCheckBox m_CheckBoxPreserveOrder;
    protected NumberTextField m_TextSeed;
    protected DefaultComboBoxModel<String> m_ModelDatasets;
    protected FileChooserPanel m_PanelModel;

    public String globalInfo() {
        return "Builds a model on a training set and serializes it to disk.";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = BuildModel.getProperties();
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelOptions.add((Component)this.m_PanelParameters, "Center");
        this.m_ModelDatasets = new DefaultComboBoxModel();
        this.m_ComboBoxDatasets = new BaseComboBox(this.m_ModelDatasets);
        this.m_ComboBoxDatasets.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Dataset", this.m_ComboBoxDatasets);
        this.m_CheckBoxPreserveOrder = new BaseCheckBox();
        this.m_CheckBoxPreserveOrder.setSelected(props.getBoolean("Cluster.BuildModelPreserveOrder", Boolean.valueOf(false)).booleanValue());
        this.m_CheckBoxPreserveOrder.setToolTipText("No randomization is performed if checked");
        this.m_CheckBoxPreserveOrder.addActionListener(e -> this.update());
        this.m_PanelParameters.addParameter("Preserve order", (Component)this.m_CheckBoxPreserveOrder);
        this.m_TextSeed = new NumberTextField(NumberTextField.Type.INTEGER, "" + props.getInteger("Cluster.BuildModelSeed", Integer.valueOf(1)));
        this.m_TextSeed.setToolTipText("The seed value for randomizing the data");
        this.m_TextSeed.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BuildModel.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BuildModel.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BuildModel.this.update();
            }
        });
        this.m_PanelParameters.addParameter("Seed", (Component)this.m_TextSeed);
        this.m_PanelModel = new FileChooserPanel();
        this.m_PanelModel.setCurrentDirectory((File)new PlaceholderFile(props.getPath("Cluster.ModelDirectory", "%c")));
        ExtensionFileFilter filter = ExtensionFileFilter.getModelFileFilter();
        this.m_PanelModel.addChoosableFileFilter((FileFilter)filter);
        this.m_PanelModel.setFileFilter((FileFilter)filter);
        this.m_PanelModel.setAcceptAllFileFilterUsed(true);
        this.m_PanelModel.addChangeListener(e -> this.update());
        this.m_PanelParameters.addParameter("Model", (Component)this.m_PanelModel);
    }

    @Override
    public String getName() {
        return "Build model";
    }

    @Override
    public String canEvaluate(Clusterer clusterer) {
        if (!this.isValidDataIndex(this.m_ComboBoxDatasets)) {
            return "No data available!";
        }
        if (!Utils.isInteger((String)this.m_TextSeed.getText())) {
            return "Seed value is not an integer!";
        }
        File file = (File)this.m_PanelModel.getCurrent();
        if (file.isDirectory()) {
            return "Model points to directory: " + file;
        }
        Instances data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        Capabilities caps = clusterer.getCapabilities();
        try {
            if (!caps.test(data)) {
                if (caps.getFailReason() != null) {
                    return caps.getFailReason().getMessage();
                }
                return "Clusterer cannot handle data!";
            }
        }
        catch (Exception e) {
            return "Clusterer cannot handle data: " + e;
        }
        return null;
    }

    @Override
    public ResultItem init(Clusterer clusterer) throws Exception {
        Instances data = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex()).getData();
        ResultItem result = new ResultItem(clusterer, new Instances(data, 0));
        return result;
    }

    @Override
    protected void doEvaluate(Clusterer clusterer, ResultItem item) throws Exception {
        Clusterer model = (Clusterer)OptionUtils.shallowCopy((Object)clusterer);
        String msg = this.canEvaluate(model);
        if (msg != null) {
            throw new IllegalArgumentException("Cannot evaluate clusterer!\n" + msg);
        }
        DataContainer dataCont = ((ClusterTab)this.getOwner()).getData().get(this.m_ComboBoxDatasets.getSelectedIndex());
        Instances data = dataCont.getData();
        Instances header = new Instances(data, 0);
        boolean order = this.m_CheckBoxPreserveOrder.isSelected();
        int seed = this.m_TextSeed.getValue().intValue();
        ((ClusterTab)this.getOwner()).logMessage("Using '" + dataCont.getID() + "/" + data.relationName() + "' to build " + OptionUtils.getCommandLine((Object)clusterer));
        if (!order) {
            data.randomize(new Random(seed));
        }
        model.buildClusterer(data);
        ((ClusterTab)this.getOwner()).logMessage("Built model on '" + dataCont.getID() + "/" + data.relationName() + "' using " + OptionUtils.getCommandLine((Object)clusterer));
        SerializationHelper.writeAll((String)((File)this.m_PanelModel.getCurrent()).getAbsolutePath(), (Object[])new Object[]{model, header});
        ((ClusterTab)this.getOwner()).logMessage("Saved model built on '" + dataCont.getID() + "/" + data.relationName() + "' to " + ((File)this.m_PanelModel.getCurrent()).getAbsolutePath());
        MetaData runInfo = new MetaData();
        runInfo.add("Clusterer", (Object)OptionUtils.getCommandLine((Object)clusterer));
        runInfo.add("Dataset ID", (Object)dataCont.getID());
        runInfo.add("Relation", (Object)data.relationName());
        runInfo.add("# Attributes", (Object)data.numAttributes());
        runInfo.add("# Instances", (Object)data.numInstances());
        runInfo.add("Preserve order", (Object)order);
        if (!order) {
            runInfo.add("Seed", (Object)seed);
        }
        runInfo.add("Model file", (Object)((File)this.m_PanelModel.getCurrent()).getAbsolutePath());
        this.addObjectSize(runInfo, "Model size", model);
        item.update(null, model, runInfo);
    }

    @Override
    public void update() {
        if (this.getOwner() == null) {
            return;
        }
        if (((ClusterTab)this.getOwner()).getOwner() == null) {
            return;
        }
        List<String> datasets = DatasetHelper.generateDatasetList(((ClusterTab)this.getOwner()).getData());
        int index = DatasetHelper.indexOfDataset(((ClusterTab)this.getOwner()).getData(), (String)this.m_ComboBoxDatasets.getSelectedItem());
        if (DatasetHelper.hasDataChanged(datasets, this.m_ModelDatasets)) {
            this.m_ModelDatasets = new DefaultComboBoxModel<String>(datasets.toArray(new String[datasets.size()]));
            this.m_ComboBoxDatasets.setModel(this.m_ModelDatasets);
            if (index == -1 && this.m_ModelDatasets.getSize() > 0) {
                this.m_ComboBoxDatasets.setSelectedIndex(0);
            } else if (index > -1) {
                this.m_ComboBoxDatasets.setSelectedIndex(index);
            }
        }
        ((ClusterTab)this.getOwner()).updateButtons();
    }

    @Override
    public void activate(int index) {
        this.m_ComboBoxDatasets.setSelectedIndex(index);
    }

    @Override
    public Map<String, Object> serialize(Set<AbstractInvestigatorTab.SerializationOption> options) {
        Map<String, Object> result = super.serialize(options);
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.GUI)) {
            result.put(KEY_DATASET, this.m_ComboBoxDatasets.getSelectedIndex());
        }
        if (options.contains((Object)AbstractInvestigatorTab.SerializationOption.PARAMETERS)) {
            result.put(KEY_PRESERVEORDER, this.m_CheckBoxPreserveOrder.isSelected());
            result.put(KEY_SEED, this.m_TextSeed.getValue().intValue());
            result.put(KEY_MODEL, ((File)this.m_PanelModel.getCurrent()).getAbsolutePath());
        }
        return result;
    }

    @Override
    public void deserialize(Map<String, Object> data, MessageCollection errors) {
        super.deserialize(data, errors);
        if (data.containsKey(KEY_DATASET)) {
            this.m_ComboBoxDatasets.setSelectedIndex(((Number)data.get(KEY_DATASET)).intValue());
        }
        if (data.containsKey(KEY_PRESERVEORDER)) {
            this.m_CheckBoxPreserveOrder.setSelected(((Boolean)data.get(KEY_PRESERVEORDER)).booleanValue());
        }
        if (data.containsKey(KEY_SEED)) {
            this.m_TextSeed.setValue((Number)((Number)data.get(KEY_SEED)).intValue());
        }
        if (data.containsKey(KEY_MODEL)) {
            this.m_PanelModel.setCurrent((File)new PlaceholderFile((String)data.get(KEY_MODEL)));
        }
    }
}

