/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.clustertab.output;

import adams.core.MessageCollection;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.tools.wekainvestigator.output.TextualContentPanel;
import adams.gui.tools.wekainvestigator.tab.clustertab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.clustertab.output.AbstractOutputGenerator;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class Supplementary
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;
    protected String m_Title;

    public String globalInfo() {
        return "Outputs the supplementary data (e.g., cross-validation result) if available.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Title = "Supplementary";
    }

    @Override
    public String getTitle() {
        return this.m_Title;
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasSupplementaryData();
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        if (!item.hasSupplementaryData()) {
            errors.add("No supplementary data available!");
            return null;
        }
        if (item.hasSupplementaryName()) {
            this.m_Title = item.getSupplementaryName();
        }
        BaseTextArea text = new BaseTextArea();
        text.setEditable(false);
        text.setTextFont(Fonts.getMonospacedFont());
        text.setText(item.getSupplementaryData().toString());
        text.setCaretPosition(0);
        return new TextualContentPanel((JTextComponent)text, true);
    }
}

