/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.preprocesstab;

import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTable;
import adams.gui.core.FilterPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.SortableAndSearchableTableWithButtons;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.core.Attribute;
import weka.core.Instances;

public class AttributeSelectionPanel
extends BasePanel
implements TableModelListener,
ListSelectionListener {
    private static final long serialVersionUID = 627131485290359194L;
    protected BaseButton m_ButtonAll;
    protected BaseButton m_ButtonNone;
    protected BaseButton m_ButtonInvert;
    protected BaseButton m_ButtonPattern;
    protected FilterPanel m_PanelFilter;
    protected SortableAndSearchableTableWithButtons m_Table;
    protected AttributeTableModel m_Model;
    protected String m_PatternRegEx;
    protected Set<ChangeListener> m_ChangeListeners;
    protected Set<ListSelectionListener> m_SelectionListeners;

    protected void initialize() {
        super.initialize();
        this.m_PatternRegEx = "";
        this.m_ChangeListeners = new HashSet<ChangeListener>();
        this.m_SelectionListeners = new HashSet<ListSelectionListener>();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Table = new SortableAndSearchableTableWithButtons();
        this.m_Table.setAutoResizeMode(0);
        this.m_Table.setSelectionMode(0);
        this.m_Table.getSelectionModel().addListSelectionListener(this);
        this.add((Component)this.m_Table, "Center");
        this.m_ButtonAll = new BaseButton("All");
        this.m_ButtonAll.setToolTipText("Selects all attributes");
        this.m_ButtonAll.addActionListener(e -> this.m_Model.selectAll());
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonAll);
        this.m_ButtonNone = new BaseButton("None");
        this.m_ButtonNone.setToolTipText("Unselects all attributes");
        this.m_ButtonNone.addActionListener(e -> this.m_Model.selectNone());
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonNone);
        this.m_ButtonInvert = new BaseButton("Invert");
        this.m_ButtonInvert.setToolTipText("Inverts the current attribute selection");
        this.m_ButtonInvert.addActionListener(e -> this.m_Model.invert());
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonInvert);
        this.m_ButtonPattern = new BaseButton("Pattern");
        this.m_ButtonPattern.setToolTipText("Selects all attributes that match a reg. expression");
        this.m_ButtonPattern.addActionListener(e -> {
            String patternStr = GUIHelper.showInputDialog((Component)this.m_ButtonPattern.getParent(), (String)"Enter a regular expression", (String)this.m_PatternRegEx);
            if (patternStr != null) {
                try {
                    Pattern.compile(patternStr);
                    this.m_PatternRegEx = patternStr;
                    this.m_Model.applyPattern(patternStr);
                }
                catch (Exception ex) {
                    GUIHelper.showErrorMessage((Component)this.m_ButtonPattern.getParent(), (String)("'" + patternStr + "' is not a valid regular expression!"), (Throwable)ex, (String)"Error in Pattern...");
                }
            }
        });
        this.m_Table.addToButtonsPanel((Component)this.m_ButtonPattern);
        this.m_PanelFilter = new FilterPanel(1);
        this.m_PanelFilter.setToolTipText("For filtering the attribute names");
        this.m_PanelFilter.addChangeListener(e -> this.search());
        this.m_PanelFilter.setPreferredSize(new Dimension(150, GUIHelper.getPreferredButtonHeight()));
        this.m_Table.addToButtonsPanel((Component)this.m_PanelFilter);
    }

    protected void finishInit() {
        super.finishInit();
        this.updateWidgets();
    }

    protected void updateWidgets() {
        boolean dataLoaded = this.getInstances() != null;
        this.m_ButtonAll.setEnabled(dataLoaded);
        this.m_ButtonNone.setEnabled(dataLoaded);
        this.m_ButtonInvert.setEnabled(dataLoaded);
        this.m_ButtonPattern.setEnabled(dataLoaded);
        this.m_PanelFilter.setEnabled(dataLoaded);
    }

    public void setInstances(Instances data) {
        if (this.m_Model != null) {
            this.m_Model.removeTableModelListener(this);
        }
        this.m_Model = new AttributeTableModel(data);
        this.m_Model.addTableModelListener(this);
        this.m_Table.setModel((TableModel)this.m_Model);
        TableColumnModel colModel = this.m_Table.getColumnModel();
        colModel.getColumn(0).setMaxWidth(60);
        colModel.getColumn(1).setMaxWidth(colModel.getColumn(1).getMinWidth());
        colModel.getColumn(2).setMinWidth(100);
        this.updateWidgets();
        if (!this.m_PanelFilter.getFilter().isEmpty()) {
            this.search();
        }
    }

    public Instances getInstances() {
        if (this.m_Model == null) {
            return null;
        }
        return this.m_Model.getInstances();
    }

    protected void search() {
        if (this.getInstances() == null) {
            return;
        }
        this.m_Table.search(this.m_PanelFilter.getFilter(), false);
    }

    public int[] getSelectedRows() {
        return this.m_Table.getSelectedRows();
    }

    public void setSelectedAttributes(boolean[] selected) throws Exception {
        if (this.m_Model != null) {
            this.m_Model.setSelectedAttributes(selected);
        }
    }

    public int[] getSelectedAttributes() {
        return this.m_Model == null ? null : this.m_Model.getSelectedAttributes();
    }

    public BaseTable getTable() {
        return this.m_Table.getComponent();
    }

    public TableModel getTableModel() {
        return this.m_Model;
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_Table.getSelectionModel();
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.notifyChangeListeners();
    }

    public void addSelectionListener(ListSelectionListener l) {
        this.m_SelectionListeners.add(l);
    }

    public void removeSelectionListener(ListSelectionListener l) {
        this.m_SelectionListeners.remove(l);
    }

    protected void notifySelectionListeners(ListSelectionEvent e) {
        for (ListSelectionListener l : this.m_SelectionListeners) {
            l.valueChanged(e);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.notifySelectionListeners(e);
    }

    public static class AttributeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4152987434024338064L;
        protected Instances m_Instances;
        protected HashMap<String, Boolean> m_Selected;

        public AttributeTableModel(Instances instances) {
            this.setInstances(instances);
        }

        public void setInstances(Instances instances) {
            this.m_Instances = instances;
            this.m_Selected = new HashMap();
            this.fireTableStructureChanged();
        }

        public Instances getInstances() {
            return this.m_Instances;
        }

        @Override
        public int getRowCount() {
            if (this.m_Instances == null) {
                return 0;
            }
            return this.m_Instances.numAttributes();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.m_Instances == null) {
                return null;
            }
            if (row >= this.m_Instances.numAttributes()) {
                return null;
            }
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return this.m_Selected.containsKey(this.m_Instances.attribute(row).name()) && this.m_Selected.get(this.m_Instances.attribute(row).name()) != false;
                }
                case 2: {
                    return this.m_Instances.attribute(row).name();
                }
                case 3: {
                    return Attribute.typeToString((int)this.m_Instances.attribute(row).type());
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "No.";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "Name";
                }
                case 3: {
                    return "Type";
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this.m_Instances == null) {
                return;
            }
            if (col == 1) {
                this.m_Selected.put(this.m_Instances.attribute(row).name(), (Boolean)value);
                this.fireTableRowsUpdated(0, this.getRowCount());
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (this.m_Instances == null) {
                return Object.class;
            }
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public int[] getSelectedAttributes() {
            TIntArrayList result = new TIntArrayList();
            if (this.m_Instances != null) {
                for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                    String name = this.m_Instances.attribute(i).name();
                    if (!this.m_Selected.containsKey(name) || !this.m_Selected.get(name).booleanValue()) continue;
                    result.add(i);
                }
            }
            return result.toArray();
        }

        public void selectAll() {
            if (this.m_Instances == null) {
                return;
            }
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                this.m_Selected.put(this.m_Instances.attribute(i).name(), true);
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }

        public void selectNone() {
            if (this.m_Instances == null) {
                return;
            }
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                this.m_Selected.put(this.m_Instances.attribute(i).name(), false);
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }

        public void invert() {
            if (this.m_Instances == null) {
                return;
            }
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                String name = this.m_Instances.attribute(i).name();
                boolean current = this.m_Selected.containsKey(name) && this.m_Selected.get(name) != false;
                this.m_Selected.put(name, !current);
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }

        public void applyPattern(String pattern) {
            if (this.m_Instances == null) {
                return;
            }
            for (int i = 0; i < this.getRowCount(); ++i) {
                String name = this.m_Instances.attribute(i).name();
                this.m_Selected.put(name, Pattern.matches(pattern, name));
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }

        public void setSelectedAttributes(boolean[] selected) throws Exception {
            if (this.m_Instances == null) {
                return;
            }
            if (selected.length != this.getRowCount()) {
                throw new Exception("Supplied array does not have the same number of elements as there are attributes!");
            }
            for (int i = 0; i < selected.length; ++i) {
                this.m_Selected.put(this.m_Instances.attribute(i).name(), selected[i]);
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }
    }
}

