/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.chooser.WekaFileChooser;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.RecentFilesHandlerWithCommandline;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.tools.wekamultiexperimenter.AnalysisPanel;
import adams.gui.tools.wekamultiexperimenter.LogPanel;
import adams.gui.tools.wekamultiexperimenter.experiment.ExperimentWithCustomizableRelationNames;
import adams.gui.tools.wekamultiexperimenter.experiment.ResettableExperiment;
import adams.gui.tools.wekamultiexperimenter.runner.AbstractExperimentRunner;
import adams.gui.tools.wekamultiexperimenter.setup.AbstractSetupPanel;
import adams.gui.tools.wekamultiexperimenter.setup.BasicWekaSetupPanel;
import adams.gui.workspace.AbstractWorkspacePanelWithStatusBar;
import java.awt.Component;
import java.io.File;
import java.util.logging.Level;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;

public class ExperimenterPanel
extends AbstractWorkspacePanelWithStatusBar {
    private static final long serialVersionUID = 7314544066929763500L;
    public static final String SESSION_FILE = "WekaMultiExperimenterSession.props";
    public static final String FILENAME = "adams/gui/tools/wekamultiexperimenter/WekaMultiExperimenter.props";
    protected static Properties m_Properties;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandlerSetups;
    protected RecentFilesHandlerWithCommandline<JMenu> m_RecentFilesHandlerResults;
    protected JMenu m_MenuItemFileLoadRecent;
    protected JMenuItem m_MenuItemFileSave;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemExecutionReset;
    protected JMenuItem m_MenuItemExecutionStart;
    protected JMenuItem m_MenuItemExecutionStop;
    protected JMenuItem m_MenuItemUseFilename;
    protected JMenuItem m_MenuItemPrefixDatasetsWithIndex;
    protected JMenu m_MenuItemResultsLoadRecent;
    protected JMenuItem m_MenuItemResultsSave;
    protected File m_CurrentFile;
    protected BaseTabbedPane m_TabbedPane;
    protected AbstractSetupPanel m_PanelSetup;
    protected AnalysisPanel m_PanelAnalysis;
    protected LogPanel m_PanelLog;
    protected WekaFileChooser m_FileChooserResults;
    protected AbstractExperimentRunner m_Runner;

    protected void initialize() {
        super.initialize();
        this.m_RecentFilesHandlerSetups = null;
        this.m_RecentFilesHandlerResults = null;
        this.m_Runner = null;
        this.m_FileChooserResults = new WekaFileChooser();
        this.m_FileChooserResults.setCurrentDirectory(new File(ExperimenterPanel.getProperties().getPath("Results.InitialDir", "%c")));
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = ExperimenterPanel.getProperties();
        this.m_StatusBar.setMouseListenerActive(true);
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        try {
            String cname = props.getProperty("Setups.InitialPanel", BasicWekaSetupPanel.class.getName());
            this.m_PanelSetup = (AbstractSetupPanel)((Object)Class.forName(cname).newInstance());
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to instantiate setups panel: " + props.getProperty("SetupsInitialPanel"), (Throwable)e);
            this.m_PanelSetup = new BasicWekaSetupPanel();
        }
        this.m_PanelSetup.setOwner(this);
        this.m_TabbedPane.addTab("Setup", (Component)((Object)this.m_PanelSetup));
        this.m_TabbedPane.setIconAt(this.m_TabbedPane.getTabCount() - 1, this.m_PanelSetup.getTabIcon());
        this.m_PanelAnalysis = new AnalysisPanel();
        this.m_PanelAnalysis.setOwner(this);
        this.m_TabbedPane.addTab("Analysis", (Component)((Object)this.m_PanelAnalysis));
        this.m_TabbedPane.setIconAt(this.m_TabbedPane.getTabCount() - 1, this.m_PanelAnalysis.getTabIcon());
        this.m_PanelLog = new LogPanel();
        this.m_PanelLog.setOwner(this);
        this.m_TabbedPane.addTab("Log", (Component)((Object)this.m_PanelLog));
        this.m_TabbedPane.setIconAt(this.m_TabbedPane.getTabCount() - 1, this.m_PanelLog.getTabIcon());
    }

    protected String getDefaultTitle() {
        return "WEKA Multi-Experimenter";
    }

    public void newSetup(Class setup) {
        AbstractSetupPanel current = (AbstractSetupPanel)((Object)this.m_TabbedPane.getComponentAt(0));
        current.setOwner(null);
        try {
            AbstractSetupPanel newSetup = (AbstractSetupPanel)((Object)setup.newInstance());
            newSetup.setOwner(this);
            this.m_TabbedPane.setComponentAt(0, (Component)((Object)newSetup));
            this.m_TabbedPane.setIconAt(0, newSetup.getTabIcon());
            this.m_PanelSetup = newSetup;
            this.logMessage("New setup: " + ((Object)((Object)this.m_PanelSetup)).getClass().getName());
        }
        catch (Exception e) {
            this.logError("Failed to instantiate setup: " + Utils.classToString((Class)setup), e, "New setup failed");
        }
    }

    public void openSetup() {
        BaseFileChooser filechooser = this.m_PanelSetup.getExperimentIO().getFileChooser();
        int retVal = filechooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        if (this.m_RecentFilesHandlerSetups != null) {
            this.m_RecentFilesHandlerSetups.addRecentItem((Object)filechooser.getSelectedFile());
        }
        this.openSetup(filechooser.getSelectedFile());
        this.update();
    }

    public void openSetup(File file) {
        this.logMessage("Loading setup from " + file + "...");
        Object exp = this.m_PanelSetup.getExperimentIO().load(file);
        String msg = exp == null ? "Failed to load experiment" : this.m_PanelSetup.handlesExperiment(exp);
        if (msg == null) {
            this.m_PanelSetup.setIgnoreChanges(true);
            this.m_PanelSetup.setExperiment(exp);
            this.updateMenuFromExperiment(exp);
            this.m_PanelSetup.setIgnoreChanges(false);
            this.m_PanelSetup.setModified(false);
            this.m_CurrentFile = file;
            this.update();
            this.logMessage("Loaded setup from " + file);
            this.m_TabbedPane.setSelectedComponent((Component)((Object)this.m_PanelSetup));
        } else {
            this.logError("Cannot handle experiment stored in " + file + "!\n" + msg, "Load experiment");
        }
    }

    public void openRecentSetup(RecentItemEvent<JMenu, File> e) {
        this.openSetup((File)e.getItem());
    }

    public void saveSetup() {
        if (this.m_CurrentFile == null) {
            this.saveSetupAs();
            return;
        }
        this.saveSetup(this.m_CurrentFile);
    }

    public void saveSetup(File file) {
        try {
            this.logMessage("Saving experiment to " + file);
            Object exp = this.getExperiment();
            this.updateExperimentFromMenu(exp);
            this.m_PanelSetup.getExperimentIO().save(exp, file);
            this.m_PanelSetup.setModified(false);
            this.m_CurrentFile = file;
            if (this.m_RecentFilesHandlerSetups != null) {
                this.m_RecentFilesHandlerSetups.addRecentItem((Object)this.m_CurrentFile);
            }
            this.update();
            this.logMessage("Saved experiment to " + file);
        }
        catch (Exception e) {
            this.logError("Failed to save experiment to " + file + "!\n" + LoggingHelper.throwableToString((Throwable)e), "Save experiment");
        }
    }

    public void saveSetupAs() {
        BaseFileChooser filechooser = this.m_PanelSetup.getExperimentIO().getFileChooser();
        int retVal = filechooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.saveSetup(filechooser.getSelectedFile());
    }

    public boolean isExecuting() {
        return this.m_Runner != null;
    }

    public void startExecution() {
        try {
            this.m_Runner = this.m_PanelSetup.getExperimentIO().createRunner(this);
        }
        catch (Exception e) {
            this.logError("Failed to run experiment: " + LoggingHelper.throwableToString((Throwable)e), "Execution error");
            return;
        }
        this.m_Runner.start();
    }

    public void stopExecution() {
        this.m_Runner.abortExperiment();
        this.update();
    }

    public void finishExecution() {
        this.m_Runner = null;
        this.update();
    }

    public void openResults() {
        int retVal = this.m_FileChooserResults.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        AbstractFileLoader loader = (AbstractFileLoader)this.m_FileChooserResults.getReader();
        if (this.m_RecentFilesHandlerResults != null) {
            this.m_RecentFilesHandlerResults.addRecentItem((Object)new RecentFilesHandlerWithCommandline.Setup(this.m_FileChooserResults.getSelectedFile(), (Object)loader));
        }
        this.openResults(this.m_FileChooserResults.getSelectedFile(), loader);
        this.update();
    }

    public void openRecentResults(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
        this.openResults(((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile(), (AbstractFileLoader)((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getHandler());
    }

    public void openResults(File file, AbstractFileLoader loader) {
        this.logMessage("Loading results " + file + "...");
        if (loader == null) {
            loader = this.m_FileChooserResults.getReaderForFile(file);
        }
        if (loader == null) {
            this.logError("Failed to determine file loader for the following file:\n" + file, "Loading results");
            return;
        }
        try {
            loader.setFile(file);
            Instances results = loader.getDataSet();
            String msg = this.m_PanelAnalysis.handlesResults(results);
            if (msg == null) {
                this.m_PanelAnalysis.setResults(results);
                this.m_TabbedPane.setSelectedComponent((Component)((Object)this.m_PanelAnalysis));
                this.logMessage("Loaded results from " + file);
            } else {
                this.logError("Cannot handle results from " + file + "\n" + msg, "Loading results");
            }
        }
        catch (Exception e) {
            String msg = "Failed to load results from " + file + "\n" + LoggingHelper.throwableToString((Throwable)e);
            this.logError("Cannot handle results from " + file + "\n" + msg, "Loading results");
        }
    }

    public void openResultsDB() {
    }

    public void saveResults() {
        int retVal = this.m_FileChooserResults.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.saveResults(this.m_FileChooserResults.getSelectedFile(), (AbstractFileSaver)this.m_FileChooserResults.getWriter());
    }

    public void saveResults(File file) {
        AbstractFileSaver saver = this.m_FileChooserResults.getWriterForFile(file);
        if (saver == null) {
            this.logError("Failed to determine file saver for " + file, "Saving results");
        } else {
            this.saveResults(file, saver);
        }
    }

    protected void saveResults(File file, AbstractFileSaver saver) {
        try {
            this.logMessage("Saving results to " + file + "...");
            saver.setFile(file);
            saver.setInstances(this.m_PanelAnalysis.getResults());
            saver.writeBatch();
            this.logMessage("Results saved to " + file);
        }
        catch (Exception e) {
            this.logError("Failed to save results to " + file + "\n" + LoggingHelper.throwableToString((Throwable)e), "Saving results");
        }
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            JMenuItem menuitem;
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(e -> this.updateMenu());
            JMenu submenu = new JMenu("New");
            menu.add(submenu);
            submenu.setMnemonic('N');
            Class[] classes = AbstractSetupPanel.getPanels();
            String defSetup = ExperimenterPanel.getProperties().getProperty("Setups.InitialPanel", BasicWekaSetupPanel.class.getName());
            for (Class cls : classes) {
                try {
                    AbstractSetupPanel setup = (AbstractSetupPanel)((Object)cls.newInstance());
                    menuitem = new JMenuItem(setup.getSetupName());
                    if (((Object)((Object)setup)).getClass().getName().equals(defSetup)) {
                        menuitem.setIcon(GUIHelper.getIcon((String)"new.gif"));
                        menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
                    }
                    menuitem.addActionListener(e -> this.newSetup(cls));
                    submenu.add(menuitem);
                }
                catch (Exception e2) {
                    this.logError("Failed to instantiate experiment: " + cls + "\n" + LoggingHelper.throwableToString((Throwable)e2), "New experiment");
                }
            }
            menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(e -> this.openSetup());
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandlerSetups = new RecentFilesHandler(SESSION_FILE, "Setup-", ExperimenterPanel.getProperties().getInteger("Setups.MaxRecent", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandlerSetups.setAddShortcuts(true);
            this.m_RecentFilesHandlerSetups.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    ExperimenterPanel.this.openRecentSetup(e);
                }
            });
            this.m_MenuItemFileLoadRecent = submenu;
            menuitem = new JMenuItem("Save");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(e -> this.saveSetup());
            this.m_MenuItemFileSave = menuitem;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(e -> this.saveSetupAs());
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(e -> this.close());
            menu = new JMenu("Execution");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem("Start");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed R"));
            menuitem.setIcon(GUIHelper.getIcon((String)"run.gif"));
            menuitem.addActionListener(e -> this.startExecution());
            this.m_MenuItemExecutionStart = menuitem;
            menuitem = new JMenuItem("Stop");
            menu.add(menuitem);
            menuitem.setMnemonic('p');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed K"));
            menuitem.setIcon(GUIHelper.getIcon((String)"stop_blue.gif"));
            menuitem.addActionListener(e -> this.stopExecution());
            this.m_MenuItemExecutionStop = menuitem;
            menu.addSeparator();
            menuitem = new JCheckBoxMenuItem("Reset");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(e -> this.m_PanelSetup.setModified(true));
            this.m_MenuItemExecutionReset = menuitem;
            menuitem = new JCheckBoxMenuItem("Use file name");
            menu.add(menuitem);
            menuitem.setMnemonic('f');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(e -> this.m_PanelSetup.setModified(true));
            this.m_MenuItemUseFilename = menuitem;
            menuitem = new JCheckBoxMenuItem("Prefix datasets with index");
            menu.add(menuitem);
            menuitem.setMnemonic('i');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(e -> this.m_PanelSetup.setModified(true));
            this.m_MenuItemPrefixDatasetsWithIndex = menuitem;
            menu = new JMenu("Analysis");
            result.add(menu);
            menu.setMnemonic('A');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(e -> this.openResults());
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandlerResults = new RecentFilesHandlerWithCommandline(SESSION_FILE, "Results-", ExperimenterPanel.getProperties().getInteger("Results.MaxRecent", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandlerResults.setAddShortcuts(false);
            this.m_RecentFilesHandlerResults.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, RecentFilesHandlerWithCommandline.Setup>(){

                public void recentItemAdded(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                    ExperimenterPanel.this.openRecentResults(e);
                }
            });
            this.m_MenuItemResultsLoadRecent = submenu;
            menuitem = new JMenuItem("Open DB...");
            menuitem.setMnemonic('D');
            menuitem.setIcon(GUIHelper.getIcon((String)"database.gif"));
            menuitem.addActionListener(e -> this.openResultsDB());
            menuitem = new JMenuItem("Save as...");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(e -> this.saveResults());
            this.m_MenuItemResultsSave = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateTitle() {
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        String title = this.m_TitleGenerator.generate(this.m_CurrentFile, this.m_PanelSetup.isModified());
        this.setParentTitle(title);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileSave.setEnabled(this.m_PanelSetup.isModified());
        this.m_MenuItemExecutionReset.setEnabled(!this.isExecuting() && this.m_PanelSetup.getExperiment() instanceof ResettableExperiment);
        this.m_MenuItemExecutionStart.setEnabled(!this.isExecuting());
        this.m_MenuItemExecutionStop.setEnabled(this.isExecuting());
        this.m_MenuItemUseFilename.setEnabled(this.getExperiment() instanceof ExperimentWithCustomizableRelationNames);
        this.m_MenuItemPrefixDatasetsWithIndex.setEnabled(this.getExperiment() instanceof ExperimentWithCustomizableRelationNames);
        this.m_MenuItemResultsSave.setEnabled(this.m_PanelAnalysis.hasResults());
    }

    protected void updateMenuFromExperiment(Object exp) {
        if (exp instanceof ResettableExperiment) {
            this.m_MenuItemExecutionReset.setSelected(((ResettableExperiment)exp).getResetResults());
        }
        if (exp instanceof ExperimentWithCustomizableRelationNames) {
            this.m_MenuItemUseFilename.setSelected(((ExperimentWithCustomizableRelationNames)exp).getUseFilename());
            this.m_MenuItemPrefixDatasetsWithIndex.setSelected(((ExperimentWithCustomizableRelationNames)exp).getPrefixDatasetsWithIndex());
        }
    }

    protected void updateExperimentFromMenu(Object exp) {
        if (exp instanceof ResettableExperiment) {
            ((ResettableExperiment)exp).setResetResults(this.m_MenuItemExecutionReset.isSelected());
        }
        if (exp instanceof ExperimentWithCustomizableRelationNames) {
            ((ExperimentWithCustomizableRelationNames)exp).setUseFilename(this.m_MenuItemUseFilename.isSelected());
            ((ExperimentWithCustomizableRelationNames)exp).setPrefixDatasetsWithIndex(this.m_MenuItemPrefixDatasetsWithIndex.isSelected());
        }
    }

    public Object getExperiment() {
        return this.m_PanelSetup.getExperiment();
    }

    public void setExperiment(Object value) {
        this.m_PanelSetup.setExperiment(value);
    }

    public String handlesExperiment(Object exp) {
        return this.m_PanelSetup.handlesExperiment(exp);
    }

    public AnalysisPanel getAnalysisPanel() {
        return this.m_PanelAnalysis;
    }

    public boolean getResetResults() {
        return this.m_MenuItemExecutionReset != null && this.m_MenuItemExecutionReset.isSelected();
    }

    public boolean getUseFilename() {
        return this.m_MenuItemUseFilename != null && this.m_MenuItemUseFilename.isSelected();
    }

    public boolean getPrefixDatasetsWithIndex() {
        return this.m_MenuItemPrefixDatasetsWithIndex != null && this.m_MenuItemPrefixDatasetsWithIndex.isSelected();
    }

    public void logMessage(String msg) {
        this.m_StatusBar.showStatus(msg);
        this.m_PanelLog.append(msg);
    }

    public void logError(String msg, String title) {
        this.m_StatusBar.showStatus(msg);
        this.m_PanelLog.append(msg);
        GUIHelper.showErrorMessage((Component)((Object)this), (String)msg, (String)title);
    }

    public void logError(String msg, Throwable t, String title) {
        this.logError(msg + "\n" + LoggingHelper.throwableToString((Throwable)t), title);
    }

    public void showStatus(String msg) {
        if (!msg.isEmpty()) {
            this.logMessage(msg);
        }
    }

    public void showProgress(String msg) {
        this.m_StatusBar.showStatus(false, msg);
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Properties.read((String)FILENAME);
            }
            catch (Exception e) {
                String msg = "Failed to load adams/gui/tools/wekamultiexperimenter/WekaMultiExperimenter.props";
                ConsolePanel.getSingleton().append((Object)LoggingLevel.SEVERE, msg, (Throwable)e);
                System.err.println(msg + "\n" + e);
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }
}

