/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.io;

import adams.core.Utils;
import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.io.AbstractWekaExperimentIO;
import adams.gui.tools.wekamultiexperimenter.runner.AbstractExperimentRunner;
import adams.gui.tools.wekamultiexperimenter.runner.DefaultWekaExperimentRunner;
import java.io.File;
import java.util.logging.Level;
import weka.experiment.Experiment;
import weka.experiment.ExtExperiment;
import weka.experiment.RemoteExperiment;

public class DefaultWekaExperimentIO
extends AbstractWekaExperimentIO<Experiment> {
    private static final long serialVersionUID = -7678768486122004558L;

    public String globalInfo() {
        return "Handles native Weka experiments.\nSupported file extensions:\n- read: " + Utils.flatten((Object[])this.getSupportedFileExtensions(true), (String)",") + "\n- write: " + Utils.flatten((Object[])this.getSupportedFileExtensions(false), (String)",");
    }

    @Override
    public Experiment create() {
        return new ExtExperiment();
    }

    @Override
    public Experiment load(File file) {
        try {
            Object result = Experiment.read((String)file.getAbsolutePath());
            result = result instanceof RemoteExperiment ? ((RemoteExperiment)result).getBaseExperiment() : new ExtExperiment((Experiment)result);
            return result;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load experiment from " + file + "!", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean save(Experiment exp, File file) {
        try {
            Experiment.write((String)file.getAbsolutePath(), (Experiment)exp);
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write experiment to " + file + "!", (Throwable)e);
            return false;
        }
    }

    @Override
    public AbstractExperimentRunner createRunner(ExperimenterPanel owner) throws Exception {
        return new DefaultWekaExperimentRunner(owner);
    }
}

