/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.core.CleanUpHandler;
import adams.core.Index;
import adams.core.Properties;
import adams.core.Range;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.data.container.DataPoint;
import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.statistics.StatUtils;
import adams.env.Environment;
import adams.gui.chooser.DatasetFileChooserPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseList;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import adams.gui.visualization.report.ReportFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.arffviewer.ArffPanel;

public class InstanceComparePanel
extends BasePanel
implements StatusMessageHandler,
CleanUpHandler,
MenuBarProvider {
    private static final long serialVersionUID = -8521425008936364143L;
    public static final String FILENAME = "InstanceCompare.props";
    public static final String SESSION_FILE_1 = "InstanceCompareSession1.props";
    public static final String SESSION_FILE_2 = "InstanceCompareSession2.props";
    protected static Properties m_Properties;
    protected DatasetPanel m_PanelDataset1;
    protected DatasetPanel m_PanelDataset2;
    protected InstancePanel m_PanelComparison;
    protected InstancePanel m_PanelDifference;
    protected JLabel m_LabelRows;
    protected BaseList m_ListRows;
    protected DefaultListModel m_ListRowsModel;
    protected ReportFactory.Table m_ReportTable;
    protected BaseStatusBar m_StatusBar;
    protected List<String> m_RowIndex;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemReload;
    protected JMenuItem m_MenuItemLoadRecent1;
    protected JMenuItem m_MenuItemLoadRecent2;
    protected JMenu m_MenuView;
    protected JMenuItem m_MenuItemViewAntiAliasing;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler1;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler2;

    protected void initialize() {
        super.initialize();
        this.m_RecentFilesHandler1 = null;
        this.m_RecentFilesHandler2 = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelDataset1 = new DatasetPanel("File 1", "1");
        this.m_PanelDataset1.setAttributeRange("first-last");
        this.m_PanelDataset1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InstanceComparePanel.this.updateRows();
                if (InstanceComparePanel.this.m_RecentFilesHandler1 != null) {
                    InstanceComparePanel.this.m_RecentFilesHandler1.addRecentItem((Object)InstanceComparePanel.this.m_PanelDataset1.getDataset());
                }
            }
        });
        this.m_PanelDataset2 = new DatasetPanel("File 2", "2");
        this.m_PanelDataset2.setAttributeRange("first-last");
        this.m_PanelDataset2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InstanceComparePanel.this.updateRows();
                if (InstanceComparePanel.this.m_RecentFilesHandler2 != null) {
                    InstanceComparePanel.this.m_RecentFilesHandler2.addRecentItem((Object)InstanceComparePanel.this.m_PanelDataset2.getDataset());
                }
            }
        });
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add((Component)((Object)this.m_PanelDataset1));
        panel.add((Component)((Object)this.m_PanelDataset2));
        this.add(panel, "North");
        panel = new JPanel(new BorderLayout());
        this.add(panel, "Center");
        JPanel panel2 = new JPanel(new GridLayout(2, 1));
        panel.add((Component)panel2, "Center");
        this.m_PanelComparison = new InstancePanel("Compare");
        this.m_PanelComparison.setSidePanelVisible(false);
        this.m_PanelComparison.getPlot().getAxis(Axis.BOTTOM).setAxisName("Attribute index (in selected range)");
        this.m_PanelDifference = new InstancePanel("Difference");
        this.m_PanelDifference.setSidePanelVisible(false);
        this.m_PanelDifference.getPlot().getAxis(Axis.BOTTOM).setAxisName("Attribute index (in selected range)");
        panel2.add((Component)((Object)this.m_PanelComparison));
        panel2.add((Component)((Object)this.m_PanelDifference));
        panel2 = new JPanel(new GridLayout(2, 1));
        panel2.setPreferredSize(new Dimension(300, 100));
        panel.add((Component)panel2, "East");
        JPanel panel4 = new JPanel(new BorderLayout());
        panel2.add(panel4);
        JPanel panel3 = new JPanel(new BorderLayout());
        panel4.add((Component)panel3, "Center");
        this.m_ListRowsModel = new DefaultListModel();
        this.m_ListRowsModel.addElement("-none-");
        this.m_ListRows = new BaseList((ListModel)this.m_ListRowsModel);
        this.m_ListRows.setSelectionMode(0);
        this.m_ListRows.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                InstanceComparePanel.this.performComparison();
            }
        });
        this.m_LabelRows = new JLabel("Row ID");
        this.m_LabelRows.setDisplayedMnemonic('R');
        this.m_LabelRows.setLabelFor((Component)this.m_ListRows);
        panel3.add((Component)this.m_LabelRows, "North");
        panel3.add((Component)new BaseScrollPane((Component)this.m_ListRows), "Center");
        this.m_ReportTable = ReportFactory.getTable(null);
        this.m_ReportTable.setAutoResizeMode(0);
        this.m_ReportTable.setNumDecimals(3);
        panel3 = new JPanel(new BorderLayout());
        panel3.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        panel3.add((Component)new BaseScrollPane((Component)this.m_ReportTable), "Center");
        panel2.add(panel3);
        this.m_StatusBar = new BaseStatusBar();
        panel.add((Component)this.m_StatusBar, "South");
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    InstanceComparePanel.this.updateMenu();
                }
            });
            JMenu submenu = new JMenu("Load recent (1st file)");
            menu.add(submenu);
            this.m_RecentFilesHandler1 = new RecentFilesHandler(SESSION_FILE_1, InstanceComparePanel.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandler1.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    InstanceComparePanel.this.setFirstDataset((File)e.getItem());
                }
            });
            this.m_MenuItemLoadRecent1 = submenu;
            submenu = new JMenu("Load recent (2nd file)");
            menu.add(submenu);
            this.m_RecentFilesHandler2 = new RecentFilesHandler(SESSION_FILE_2, InstanceComparePanel.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandler2.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    InstanceComparePanel.this.setSecondDataset((File)e.getItem());
                }
            });
            this.m_MenuItemLoadRecent2 = submenu;
            JMenuItem menuitem = new JMenuItem("Reload");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"F5"));
            menuitem.setIcon(GUIHelper.getIcon((String)"refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceComparePanel.this.reload();
                }
            });
            this.m_MenuItemReload = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceComparePanel.this.close();
                }
            });
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    InstanceComparePanel.this.updateMenu();
                }
            });
            this.m_MenuView = menu;
            menuitem = new JCheckBoxMenuItem("Anti-aliasing");
            menu.add(menuitem);
            menuitem.setMnemonic('A');
            menuitem.setSelected(this.m_PanelComparison.isAntiAliasingEnabled());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceComparePanel.this.m_PanelComparison.setAntiAliasingEnabled(InstanceComparePanel.this.m_MenuItemViewAntiAliasing.isSelected());
                    InstanceComparePanel.this.m_PanelDifference.setAntiAliasingEnabled(InstanceComparePanel.this.m_MenuItemViewAntiAliasing.isSelected());
                }
            });
            this.m_MenuItemViewAntiAliasing = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean dataLoaded = this.m_PanelDataset1.hasDataset() && this.m_PanelDataset2.hasDataset();
        this.m_MenuItemLoadRecent1.setEnabled(this.m_RecentFilesHandler1 != null && this.m_RecentFilesHandler1.size() > 0);
        this.m_MenuItemLoadRecent2.setEnabled(this.m_RecentFilesHandler2 != null && this.m_RecentFilesHandler2.size() > 0);
        this.m_MenuItemReload.setEnabled(dataLoaded);
    }

    public void reload() {
        this.m_PanelDataset1.reload();
        this.m_PanelDataset2.reload();
    }

    public void close() {
        this.cleanUp();
        this.closeParent();
    }

    protected List<String> trimIDs(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String row : list) {
            result.add(row.replaceAll("^[0]*", ""));
        }
        return result;
    }

    protected void updateRows() {
        List<String> rows;
        this.showStatus("Updating...");
        List<String> rows1 = this.m_PanelDataset1.getRows();
        List<String> rows2 = this.m_PanelDataset2.getRows();
        ArrayList<String> rowsCommon = new ArrayList<String>(rows1);
        rowsCommon.retainAll(rows2);
        if (!this.m_PanelDataset1.isString() && !this.m_PanelDataset2.isString()) {
            this.m_RowIndex = rowsCommon;
            rows = this.trimIDs(rowsCommon);
            this.showStatus("");
        } else {
            this.m_RowIndex = rows1.size() > rows2.size() ? rows1 : rows2;
            rows = !this.m_PanelDataset1.isString() ? this.trimIDs(this.m_RowIndex) : this.m_RowIndex;
            this.showStatus("Attributes differ in type, cannot match rows!");
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String row : rows) {
            model.addElement(row);
        }
        this.m_ListRowsModel = model;
        this.m_ListRowsModel.insertElementAt("-none-", 0);
        this.m_ListRows.setModel((ListModel)this.m_ListRowsModel);
        this.m_ListRows.setSelectedIndex(0);
        if (this.m_ListRowsModel.size() <= 1) {
            this.m_LabelRows.setText("Row ID");
        } else {
            this.m_LabelRows.setText("Row ID (" + (this.m_ListRowsModel.size() - 1) + ")");
        }
    }

    protected void performComparison() {
        InstanceContainer cont;
        InstanceContainerManager managerComp = (InstanceContainerManager)this.m_PanelComparison.getContainerManager();
        InstanceContainerManager managerDiff = (InstanceContainerManager)this.m_PanelDifference.getContainerManager();
        managerComp.clear();
        managerDiff.clear();
        this.m_ReportTable.setModel((TableModel)ReportFactory.getModel(null));
        this.m_ReportTable.setOptimalColumnWidth();
        if (this.m_ListRows.getSelectedIndex() < 1) {
            return;
        }
        if (this.m_RowIndex == null) {
            return;
        }
        String row = this.m_RowIndex.get(this.m_ListRows.getSelectedIndex() - 1);
        Instance inst1 = this.m_PanelDataset1.getRow(row);
        Instance inst2 = this.m_PanelDataset2.getRow(row);
        managerComp.startUpdate();
        if (inst1 != null) {
            cont = managerComp.newContainer((Comparable)((Object)inst1));
            managerComp.add(cont);
        }
        if (inst2 != null) {
            cont = managerComp.newContainer((Comparable)((Object)inst2));
            managerComp.add(cont);
        }
        managerComp.finishUpdate();
        if (inst1 == null || inst2 == null) {
            this.showStatus("Instance only available in dataset " + (inst1 != null ? "1" : "2"));
        } else if (inst1.size() != inst2.size()) {
            this.showStatus("Instances differ in size: " + inst1.size() + " != " + inst2.size());
        } else {
            this.showStatus("");
            Instance instDiff = new Instance();
            Iterator iter1 = inst1.iterator();
            Iterator iter2 = inst2.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                InstancePoint point1 = (InstancePoint)((Object)iter1.next());
                InstancePoint point2 = (InstancePoint)((Object)iter2.next());
                InstancePoint pointDiff = new InstancePoint(point1.getX(), point1.getY() - point2.getY());
                instDiff.add((DataPoint)pointDiff);
            }
            Report reportDiff = instDiff.getReport();
            double[] values1 = inst1.toDoubleArray();
            double[] values2 = inst2.toDoubleArray();
            Field field = new Field("Correlation coefficient", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.correlationCoefficient((double[])values1, (double[])values2));
            field = new Field("Root mean squared error", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.rmse((double[])values1, (double[])values2));
            field = new Field("Root relative squared error", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.rrse((double[])values1, (double[])values2));
            field = new Field("Mean absolute error", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.mae((double[])values1, (double[])values2));
            field = new Field("Relative absolute error", DataType.NUMERIC);
            reportDiff.addField((AbstractField)field);
            reportDiff.setValue((AbstractField)field, (Object)StatUtils.rae((double[])values1, (double[])values2));
            managerDiff.startUpdate();
            cont = managerComp.newContainer((Comparable)((Object)instDiff));
            cont.setID((String)this.m_ListRows.getSelectedValue());
            managerDiff.add(cont);
            managerDiff.finishUpdate();
            this.m_ReportTable.setModel((TableModel)ReportFactory.getModel((Report)reportDiff));
            this.m_ReportTable.setOptimalColumnWidth();
        }
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public void setFirstDataset(File value) {
        this.m_PanelDataset1.setDataset(value);
    }

    public File getFirstDataset() {
        return this.m_PanelDataset1.getDataset();
    }

    public void setFirstAttributeRange(String value) {
        this.m_PanelDataset1.setAttributeRange(value);
    }

    public String getFirstAttributeRange() {
        return this.m_PanelDataset1.getAttributeRange();
    }

    public void setFirstRowIndex(String value) {
        this.m_PanelDataset1.setRowIndex(value);
    }

    public String getFirstRowIndex() {
        return this.m_PanelDataset1.getRowIndex();
    }

    public void setSecondDataset(File value) {
        this.m_PanelDataset2.setDataset(value);
    }

    public File getSecondDataset() {
        return this.m_PanelDataset2.getDataset();
    }

    public void setSecondAttributeRange(String value) {
        this.m_PanelDataset2.setAttributeRange(value);
    }

    public String getSecondAttributeRange() {
        return this.m_PanelDataset2.getAttributeRange();
    }

    public void setSecondRowIndex(String value) {
        this.m_PanelDataset2.setRowIndex(value);
    }

    public String getSecondRowIndex() {
        return this.m_PanelDataset2.getRowIndex();
    }

    public void cleanUp() {
        this.m_PanelDifference.cleanUp();
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("instance compare");
        }
        return m_Properties;
    }

    public static class DatasetPanel
    extends BasePanel {
        private static final long serialVersionUID = -5445797307951816941L;
        protected DatasetIndexer m_Indexer;
        protected String m_BorderTitle;
        protected String m_ID;
        protected DatasetFileChooserPanel m_PanelDataset;
        protected BaseButton m_ButtonDisplay;
        protected BaseTextField m_TextAttributeRange;
        protected JLabel m_LabelAttributeRange;
        protected BaseComboBox m_ComboBoxRowAttribute;
        protected DefaultComboBoxModel m_ComboBoxRowAttributeModel;
        protected JLabel m_LabelRowAttribute;
        protected HashSet<ChangeListener> m_ChangeListeners;

        public DatasetPanel(String title, String id) {
            this.setBorderTitle(title);
            this.setID(id);
        }

        protected void initialize() {
            super.initialize();
            this.m_Indexer = new DatasetIndexer();
            this.m_ChangeListeners = new HashSet();
        }

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new GridLayout(2, 1));
            this.m_PanelDataset = new DatasetFileChooserPanel();
            this.m_PanelDataset.setTextColumns(25);
            this.m_PanelDataset.setPrefix("File");
            this.m_PanelDataset.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.loadDataset();
                    this.update();
                }
            });
            this.m_ButtonDisplay = new BaseButton("Display");
            this.m_ButtonDisplay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.displayDataset();
                }
            });
            JPanel panel = new JPanel(new FlowLayout(0));
            panel.add((Component)((Object)this.m_PanelDataset));
            panel.add((Component)this.m_ButtonDisplay);
            this.add(panel);
            this.m_TextAttributeRange = new BaseTextField(10);
            this.m_TextAttributeRange.setToolTipText(GUIHelper.processTipText((String)new Range().getExample(), (int)40));
            this.m_TextAttributeRange.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                protected void update() {
                    String oldRange = m_Indexer.getRange();
                    m_Indexer.setRange(m_TextAttributeRange.getText());
                    if (!oldRange.equals(m_Indexer.getRange())) {
                        this.fireSetupChanged();
                    }
                }
            });
            this.m_LabelAttributeRange = new JLabel("Att. range");
            this.m_LabelAttributeRange.setLabelFor((Component)this.m_TextAttributeRange);
            this.m_ComboBoxRowAttributeModel = new DefaultComboBoxModel();
            this.m_ComboBoxRowAttributeModel.addElement("-none-");
            this.m_ComboBoxRowAttribute = new BaseComboBox((ComboBoxModel)this.m_ComboBoxRowAttributeModel);
            this.m_ComboBoxRowAttribute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = m_ComboBoxRowAttribute.getSelectedIndex();
                    if (index < 1) {
                        m_Indexer.setAttributeIndex("");
                    } else {
                        m_Indexer.setAttributeIndex("" + index);
                    }
                    this.fireSetupChanged();
                }
            });
            this.m_LabelRowAttribute = new JLabel("Row att.");
            this.m_LabelRowAttribute.setLabelFor((Component)this.m_ComboBoxRowAttribute);
            panel = new JPanel(new FlowLayout(0));
            panel.add(this.m_LabelAttributeRange);
            panel.add((Component)this.m_TextAttributeRange);
            panel.add(this.m_LabelRowAttribute);
            panel.add((Component)this.m_ComboBoxRowAttribute);
            this.add(panel);
            this.m_ButtonDisplay.setPreferredSize(new Dimension((int)this.m_ButtonDisplay.getPreferredSize().getWidth(), (int)this.m_PanelDataset.getPreferredSize().getHeight()));
            this.m_ComboBoxRowAttribute.setPreferredSize(new Dimension(150, (int)this.m_ComboBoxRowAttribute.getPreferredSize().getHeight()));
            this.setBorderTitle("File");
            this.update();
        }

        public void setBorderTitle(String value) {
            this.m_BorderTitle = value;
            this.setBorder(BorderFactory.createTitledBorder(this.m_BorderTitle));
        }

        public String getBorderTitle() {
            return this.m_BorderTitle;
        }

        public void setID(String value) {
            this.m_ID = value;
        }

        public String getID() {
            return this.m_ID;
        }

        public void setDataset(File value) {
            this.m_PanelDataset.setCurrent(value);
            this.m_PanelDataset.fireCurrentValueChanged();
        }

        public File getDataset() {
            return (File)this.m_PanelDataset.getCurrent();
        }

        public boolean hasDataset() {
            return ((File)this.m_PanelDataset.getCurrent()).isFile() && ((File)this.m_PanelDataset.getCurrent()).exists();
        }

        public void setAttributeRange(String value) {
            this.m_Indexer.setRange(value);
            this.m_TextAttributeRange.setText(this.m_Indexer.getRange());
        }

        public String getAttributeRange() {
            return this.m_Indexer.getRange();
        }

        public void setRowIndex(String value) {
            int index = -1;
            if (value.toLowerCase().equals("first")) {
                index = 0;
            } else if (value.toLowerCase().equals("last")) {
                if (this.m_Indexer.getDataset() != null) {
                    index = this.m_Indexer.getDataset().numAttributes() - 1;
                }
            } else if (value.length() > 0) {
                index = Integer.parseInt(value) - 1;
            }
            this.m_ComboBoxRowAttribute.setSelectedIndex(index + 1);
        }

        public String getRowIndex() {
            int index = this.m_ComboBoxRowAttribute.getSelectedIndex();
            if (index == 0) {
                return "";
            }
            if (index == 1) {
                return "first";
            }
            if (index == this.m_ComboBoxRowAttributeModel.getSize()) {
                return "last";
            }
            return Integer.toString(index);
        }

        protected void update() {
            this.m_ButtonDisplay.setEnabled(this.m_Indexer.getDataset() != null);
        }

        public void reload() {
            if (!this.hasDataset()) {
                return;
            }
            String attRange = this.getAttributeRange();
            String rowIndex = this.getRowIndex();
            this.loadDataset();
            this.setAttributeRange(attRange);
            this.setRowIndex(rowIndex);
        }

        protected void loadDataset() {
            Instances dataset;
            try {
                dataset = ConverterUtils.DataSource.read((String)((File)this.m_PanelDataset.getCurrent()).getAbsolutePath());
                this.m_ComboBoxRowAttributeModel = new DefaultComboBoxModel();
                this.m_ComboBoxRowAttributeModel.addElement("-none-");
                for (int i = 0; i < dataset.numAttributes(); ++i) {
                    this.m_ComboBoxRowAttributeModel.addElement(i + 1 + ": " + dataset.attribute(i).name());
                }
                this.m_ComboBoxRowAttribute.setModel((ComboBoxModel)this.m_ComboBoxRowAttributeModel);
                this.m_ComboBoxRowAttribute.setSelectedIndex(0);
            }
            catch (Exception e) {
                dataset = null;
                e.printStackTrace();
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Error loading dataset from '" + ((File)this.m_PanelDataset.getCurrent()).getAbsolutePath() + "':\n" + e));
            }
            this.m_Indexer.setDataset(dataset);
            this.update();
            this.fireSetupChanged();
        }

        protected void displayDataset() {
            final BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(this.getParentFrame(), true);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle(this.m_Indexer.getDataset().relationName());
            dialog.getContentPane().setLayout(new BorderLayout());
            ArffPanel arffpanel = new ArffPanel(this.m_Indexer.getDataset());
            dialog.getContentPane().add((Component)arffpanel, "Center");
            BaseButton buttonClose = new BaseButton("Close", (Icon)GUIHelper.getIcon((String)"exit.png"));
            buttonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                }
            });
            JPanel panel = new JPanel(new FlowLayout(2));
            panel.add((Component)buttonClose);
            dialog.getContentPane().add((Component)panel, "South");
            dialog.pack();
            dialog.setSize(GUIHelper.getDefaultDialogDimension());
            if (this.getParentDialog() != null) {
                dialog.setLocationRelativeTo((Component)this.getParentDialog());
            } else {
                dialog.setLocationRelativeTo((Component)this.getParentFrame());
            }
            dialog.setVisible(true);
        }

        public List<String> getRows() {
            return this.m_Indexer.getRows();
        }

        public Instance getRow(String row) {
            Instance result = this.m_Indexer.getRow(row);
            if (result != null) {
                result.setID(this.m_ID);
            }
            return result;
        }

        public boolean isString() {
            return this.m_Indexer.isString();
        }

        public void addChangeListener(ChangeListener l) {
            this.m_ChangeListeners.add(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.m_ChangeListeners.remove(l);
        }

        protected void notifyChangeListeners(ChangeEvent e) {
            for (ChangeListener l : this.m_ChangeListeners) {
                l.stateChanged(e);
            }
        }

        public void fireSetupChanged() {
            this.notifyChangeListeners(new ChangeEvent((Object)this));
        }
    }

    public static class DatasetIndexer
    implements Serializable {
        private static final long serialVersionUID = -632800897294222906L;
        public static final int MAX_DECIMAL = 6;
        protected Instances m_Dataset = null;
        protected Index m_AttributeIndex = new Index();
        protected Range m_Range = new Range();
        protected TreeMap<String, Integer> m_Index;
        protected Boolean m_IsString;
        protected Remove m_Remove;

        public DatasetIndexer() {
            this.reset();
        }

        protected void reset() {
            this.m_Index = null;
            this.m_IsString = null;
            this.m_Remove = null;
        }

        public void setDataset(Instances value) {
            this.m_Dataset = value;
            this.reset();
        }

        public Instances getDataset() {
            return this.m_Dataset;
        }

        public boolean hasAttributeIndex() {
            return this.m_AttributeIndex.getIndex().length() > 0;
        }

        public void setAttributeIndex(String value) {
            this.m_AttributeIndex.setIndex(value);
            this.reset();
        }

        public String getAttributeIndex() {
            return this.m_AttributeIndex.getIndex();
        }

        public void setRange(String value) {
            this.m_Range.setRange(value);
            this.reset();
        }

        public String getRange() {
            return this.m_Range.getRange();
        }

        protected synchronized void initialize() {
            if (this.m_Index == null) {
                this.m_Index = new TreeMap();
                if (this.m_Dataset != null) {
                    this.m_AttributeIndex.setMax(this.m_Dataset.numAttributes());
                    this.m_Range.setMax(this.m_Dataset.numAttributes());
                    int index = -1;
                    this.m_IsString = false;
                    if (this.hasAttributeIndex()) {
                        index = this.m_AttributeIndex.getIntIndex();
                        this.m_IsString = this.m_Dataset.attribute(index).isNominal() || this.m_Dataset.attribute(index).isString();
                    }
                    int width = this.m_IsString != false ? -1 : (index == -1 ? 10 : 27);
                    for (int i = 0; i < this.m_Dataset.numInstances(); ++i) {
                        if (index == -1) {
                            this.m_Index.put(Utils.padLeft((String)Integer.toString(i + 1), (char)'0', (int)width), i);
                            continue;
                        }
                        if (this.m_IsString.booleanValue()) {
                            this.m_Index.put(this.m_Dataset.instance(i).stringValue(index), i);
                            continue;
                        }
                        this.m_Index.put(Utils.padLeft((String)Utils.doubleToString((double)this.m_Dataset.instance(i).value(index), (int)6), (char)'0', (int)width), i);
                    }
                    int[] indices = this.m_Range.getIntIndices();
                    if (indices.length == this.m_Dataset.numAttributes()) {
                        this.m_Remove = null;
                    } else {
                        this.m_Remove = new Remove();
                        this.m_Remove.setAttributeIndicesArray(indices);
                        this.m_Remove.setInvertSelection(true);
                        try {
                            this.m_Remove.setInputFormat(this.m_Dataset);
                        }
                        catch (Exception e) {
                            System.err.println("Error initializing the Remove filter:");
                            e.printStackTrace();
                            this.m_Remove = null;
                        }
                    }
                }
            }
        }

        public synchronized boolean isString() {
            this.initialize();
            if (this.m_IsString == null) {
                return true;
            }
            return this.m_IsString;
        }

        public synchronized TreeMap<String, Integer> getIndex() {
            this.initialize();
            return this.m_Index;
        }

        public synchronized List<String> getRows() {
            ArrayList<String> result = new ArrayList<String>();
            this.initialize();
            result.addAll(this.m_Index.keySet());
            return result;
        }

        public synchronized Instance getRow(String row) {
            Instance result = null;
            this.initialize();
            Integer index = this.m_Index.get(row);
            if (index != null) {
                weka.core.Instance inst = this.m_Dataset.instance(index.intValue());
                if (this.m_Remove != null) {
                    this.m_Remove.input(this.m_Dataset.instance(index.intValue()));
                    try {
                        this.m_Remove.batchFinished();
                        inst = this.m_Remove.output();
                    }
                    catch (Exception e) {
                        System.err.println("Failed to filter instance #" + (index + 1) + ": " + inst);
                        e.printStackTrace();
                        inst = this.m_Dataset.instance(index.intValue());
                    }
                }
                result = new Instance();
                result.set(inst);
            }
            return result;
        }
    }
}

