/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.model.clustering;

import adams.core.option.OptionUtils;
import adams.ml.capabilities.Capabilities;
import adams.ml.data.Dataset;
import adams.ml.data.WekaConverter;
import adams.ml.model.clustering.AbstractClusterer;
import adams.ml.model.clustering.ClusteringModel;
import adams.ml.model.clustering.WekaClusteringModel;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Instances;

public class WekaClusterer
extends AbstractClusterer {
    private static final long serialVersionUID = -4086036132431888958L;
    protected Clusterer m_Clusterer;

    public String globalInfo() {
        return "Wraps around a Weka clusterer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("clusterer", "clusterer", (Object)new SimpleKMeans());
    }

    public void setClusterer(Clusterer value) {
        this.m_Clusterer = value;
        this.reset();
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The clusterer to use.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.assign(WekaConverter.convertCapabilities(this.m_Clusterer.getCapabilities()));
        return result;
    }

    protected ClusteringModel doBuildModel(Dataset data) throws Exception {
        Instances inst = WekaConverter.toInstances(data);
        Clusterer clusterer = (Clusterer)OptionUtils.shallowCopy((Object)this.m_Clusterer);
        if (clusterer == null) {
            throw new Exception("Failed to create shallow copy of classifier: " + OptionUtils.getCommandLine((Object)this.m_Clusterer));
        }
        clusterer.buildClusterer(inst);
        return new WekaClusteringModel(clusterer, data, inst);
    }
}

