/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.model.regression;

import adams.core.logging.LoggingObject;
import adams.data.spreadsheet.Row;
import adams.ml.data.Dataset;
import adams.ml.data.DatasetInfo;
import adams.ml.data.WekaConverter;
import adams.ml.model.Model;
import adams.ml.model.ModelHelper;
import adams.ml.model.regression.RegressionModel;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class WekaRegressionModel
extends LoggingObject
implements RegressionModel {
    private static final long serialVersionUID = 4557749254683230577L;
    protected Classifier m_Model;
    protected DatasetInfo m_DatasetInfo;
    protected Instances m_InstancesHeader;

    public WekaRegressionModel(Classifier model, Dataset data, Instances inst) {
        this.m_Model = model;
        this.m_DatasetInfo = new DatasetInfo(data);
        this.m_InstancesHeader = new Instances(inst, 0);
    }

    public double classify(Row row) throws Exception {
        Instance inst = WekaConverter.toInstance(this.m_InstancesHeader, row);
        if (inst == null) {
            throw new Exception("Failed to convert data row into Weka instance: " + row);
        }
        return this.m_Model.classifyInstance(inst);
    }

    public DatasetInfo getDatasetInfo() {
        return this.m_DatasetInfo;
    }

    public Instances getInstancesHeader() {
        return this.m_InstancesHeader;
    }

    public String getModelDescription() {
        return this.m_Model.toString();
    }

    public String isCompatible(Dataset data) {
        return ModelHelper.isCompatible((Model)this, (Dataset)data);
    }
}

