/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.classifiers.functions.LinearRegressionJ;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Utils;

public class LinearRegressionAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler {
    private static final long serialVersionUID = 129917929429910376L;
    protected double[] m_Ranking;
    protected LinearRegressionJ m_Model;
    protected double m_Ridge = 1.0E-8;
    protected boolean m_Minimal = false;
    protected boolean m_outputAdditionalStats;

    public String globalInfo() {
        return "Uses the coefficients of " + LinearRegressionJ.class.getName() + " to determine the importance of the attributes (attribute selection turned off, no elimination of collinear attributes):\n- absolute value of coefficients\n- intercept gets set to zero\n- all coefficients normalized (ie sum up to one)";
    }

    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSet ridge parameter (default 1.0e-8).\n", "R", 1, "-R <double>"));
        newVector.addElement(new Option("\tConserve memory, don't keep dataset header and means/stdevs.\n\tModel cannot be printed out if this option is enabled.\t(default: keep data)", "minimal", 0, "-minimal"));
        newVector.addElement(new Option("\tOutput additional statistics.", "additional-stats", 0, "-additional-stats"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String ridgeString = Utils.getOption((char)'R', (String[])options);
        if (ridgeString.length() != 0) {
            this.setRidge(Double.parseDouble(ridgeString));
        } else {
            this.setRidge(1.0E-8);
        }
        this.setMinimal(Utils.getFlag((String)"minimal", (String[])options));
        this.setOutputAdditionalStats(Utils.getFlag((String)"additional-stats", (String[])options));
    }

    public void setOutputAdditionalStats(boolean additional) {
        this.m_outputAdditionalStats = additional;
    }

    public void setMinimal(boolean value) {
        this.m_Minimal = value;
    }

    public String ridgeTipText() {
        return "The value of the Ridge parameter.";
    }

    public double getRidge() {
        return this.m_Ridge;
    }

    public void setRidge(double newRidge) {
        this.m_Ridge = newRidge;
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        result.add("" + this.getRidge());
        if (this.getMinimal()) {
            result.add("-minimal");
        }
        if (this.getOutputAdditionalStats()) {
            result.add("-additional-stats");
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean getMinimal() {
        return this.m_Minimal;
    }

    public boolean getOutputAdditionalStats() {
        return this.m_outputAdditionalStats;
    }

    public Capabilities getCapabilities() {
        Capabilities result = new LinearRegressionJ().getCapabilities();
        result.setOwner((CapabilitiesHandler)this);
        return result;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_Model = new LinearRegressionJ();
        this.m_Model.setEliminateColinearAttributes(false);
        this.m_Model.setAttributeSelectionMethod(new SelectedTag(1, LinearRegressionJ.TAGS_SELECTION));
        this.m_Model.setRidge(this.m_Ridge);
        this.m_Model.setMinimal(this.m_Minimal);
        this.m_Model.setOutputAdditionalStats(this.m_outputAdditionalStats);
        this.m_Model.buildClassifier(instances);
        double[] coefficients = this.m_Model.coefficients();
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = Math.abs(coefficients[i]);
        }
        coefficients[coefficients.length - 1] = 0.0;
        Utils.normalize((double[])coefficients);
        this.m_Ranking = coefficients;
    }

    public double evaluateAttribute(int i) throws Exception {
        return this.m_Ranking[i];
    }

    public String toString() {
        return this.m_Model.toString();
    }

    public static void main(String[] args) {
        LinearRegressionAttributeEval.runEvaluator((ASEvaluation)new LinearRegressionAttributeEval(), (String[])args);
    }
}

