/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.BatchPredictor;
import weka.core.Instances;

public class TestingHelper {
    public static void evaluateModel(Classifier model, Instances test, Evaluation eval, int interval, TestingUpdateListener listener) throws Exception {
        TestingHelper.evaluateModel(model, test, eval, interval, listener, null);
    }

    public static void evaluateModel(Classifier model, Instances test, Evaluation eval, int interval, TestingUpdateListener listener, StoppableWithFeedback owner) throws Exception {
        int batchSize = 1;
        if (model instanceof BatchPredictor && ((BatchPredictor)model).implementsMoreEfficientBatchPrediction() && Utils.isInteger((String)((BatchPredictor)model).getBatchSize())) {
            batchSize = Integer.parseInt(((BatchPredictor)model).getBatchSize());
        }
        boolean stopped = false;
        if (batchSize == 1) {
            for (int i = 0; i < test.numInstances(); ++i) {
                eval.evaluateModelOnceAndRecordPrediction(model, test.instance(i));
                if (listener != null && (i + 1) % interval == 0) {
                    listener.testingUpdateRequested(test, i + 1, test.numInstances());
                }
                if (owner == null || !owner.isStopped()) continue;
                stopped = true;
                break;
            }
        } else {
            int i = 0;
            int nextUpdate = interval;
            while (i < test.numInstances()) {
                int num = Math.min(batchSize, test.numInstances() - i);
                Instances batch = new Instances(test, i, num);
                double[][] preds = ((BatchPredictor)model).distributionsForInstances(batch);
                for (int n = 0; n < num; ++n) {
                    eval.evaluationForSingleInstance(preds[n], batch.instance(n), !eval.getDiscardPredictions());
                }
                if (nextUpdate <= (i += num)) {
                    listener.testingUpdateRequested(test, i + 1, test.numInstances());
                    nextUpdate = i + interval;
                }
                if (owner == null || !owner.isStopped()) continue;
                stopped = true;
                break;
            }
        }
        if (!stopped && listener != null) {
            listener.testingUpdateRequested(test, test.numInstances(), test.numInstances());
        }
    }

    public static interface TestingUpdateListener {
        public void testingUpdateRequested(Instances var1, int var2, int var3);
    }
}

