/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import adams.data.statistics.StatUtils;
import java.util.Arrays;
import java.util.List;
import weka.classifiers.evaluation.AbstractSimpleRegressionMeasure;
import weka.core.Utils;

public class RSquared
extends AbstractSimpleRegressionMeasure {
    private static final long serialVersionUID = 6501729731780442367L;
    public static final String NAME = "R^2";

    public String getMetricName() {
        return NAME;
    }

    public String getMetricDescription() {
        return NAME;
    }

    public List<String> getStatisticNames() {
        return Arrays.asList(NAME);
    }

    public double getStatistic(String statName) {
        if (statName.equals(NAME)) {
            if (this.m_Actual.size() == 0) {
                return Utils.missingValue();
            }
            double meanY = StatUtils.mean((double[])this.m_Actual.toArray());
            double sumSqRes = 0.0;
            double sumSqTot = 0.0;
            for (int i = 0; i < this.m_Actual.size(); ++i) {
                sumSqTot += Math.pow(this.m_Actual.get(i) - meanY, 2.0);
                sumSqRes += Math.pow(this.m_Actual.get(i) - this.m_Predicted.get(i), 2.0);
            }
            if (sumSqTot != 0.0) {
                return 1.0 - sumSqRes / sumSqTot;
            }
            return Utils.missingValue();
        }
        return Utils.missingValue();
    }

    public String toSummaryString() {
        return Utils.padRight((String)NAME, (int)41) + Utils.doubleToString((double)this.getStatistic(NAME), (int)4) + "\n";
    }
}

