/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.Utils;

public class FakeClassifier
extends AbstractClassifier
implements Randomizable,
UpdateableClassifier {
    private static final long serialVersionUID = 8430850643799590721L;
    protected int m_Seed = 1;
    protected int m_BuildWait = 0;
    protected int m_UpdateWait = 0;
    protected int m_PredictWait = 0;
    protected double m_PredictMin = 0.0;
    protected double m_PredictMax = 1.0;
    protected Random m_Random;

    public String globalInfo() {
        return "Fake classifier that requires no dataset for training and just outputs random values within the specified bounds.\nFake build and prediction times can be set as well.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe seed value to use.\n\t(default: 1)", "seed", 1, "-seed <int>"));
        result.addElement(new Option("\tThe number of msec for the classifier to idle at build time.\n\t(default: 0)", "build-wait", 1, "-build-wait <int>"));
        result.addElement(new Option("\tThe number of msec for the classifier to idle at incremental build time.\n\t(default: 0)", "update-wait", 1, "-update-wait <int>"));
        result.addElement(new Option("\tThe number of msec for the classifier to idle at prediction time.\n\t(default: 0)", "predict-wait", 1, "-predict-wait <int>"));
        result.addElement(new Option("\tThe minimum value to use for prediction.\n\t(default: 0.0)", "predict-min", 1, "-predict-min <num>"));
        result.addElement(new Option("\tThe maximum value to use for prediction.\n\t(default: 1.0)", "predict-max", 1, "-predict-max <num>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-seed");
        result.add("" + this.getSeed());
        result.add("-build-wait");
        result.add("" + this.getBuildWait());
        result.add("-update-wait");
        result.add("" + this.getUpdateWait());
        result.add("-predict-wait");
        result.add("" + this.getPredictWait());
        result.add("-predict-min");
        result.add("" + this.getPredictMin());
        result.add("-predict-max");
        result.add("" + this.getPredictMax());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"seed", (String[])options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(1);
        }
        tmpStr = Utils.getOption((String)"build-wait", (String[])options);
        if (tmpStr.length() != 0) {
            this.setBuildWait(Integer.parseInt(tmpStr));
        } else {
            this.setBuildWait(0);
        }
        tmpStr = Utils.getOption((String)"update-wait", (String[])options);
        if (tmpStr.length() != 0) {
            this.setUpdateWait(Integer.parseInt(tmpStr));
        } else {
            this.setUpdateWait(0);
        }
        tmpStr = Utils.getOption((String)"predict-wait", (String[])options);
        if (tmpStr.length() != 0) {
            this.setPredictWait(Integer.parseInt(tmpStr));
        } else {
            this.setPredictWait(0);
        }
        tmpStr = Utils.getOption((String)"predict-min", (String[])options);
        if (tmpStr.length() != 0) {
            this.setPredictMin(Double.parseDouble(tmpStr));
        } else {
            this.setPredictMin(0.0);
        }
        tmpStr = Utils.getOption((String)"predict-max", (String[])options);
        if (tmpStr.length() != 0) {
            this.setPredictMax(Double.parseDouble(tmpStr));
        } else {
            this.setPredictMax(0.0);
        }
        super.setOptions(options);
    }

    public void setSeed(int value) {
        this.m_Seed = value;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value to use for the random values.";
    }

    public void setBuildWait(int value) {
        if (value >= 0) {
            this.m_BuildWait = value;
        } else {
            System.err.println("BuildWait time must be >= 0, provided: " + value);
        }
    }

    public int getBuildWait() {
        return this.m_BuildWait;
    }

    public String buildWaitTipText() {
        return "The time in msec to wait when calling 'buildClassifier'.";
    }

    public void setUpdateWait(int value) {
        if (value >= 0) {
            this.m_UpdateWait = value;
        } else {
            System.err.println("UpdateWait time must be >= 0, provided: " + value);
        }
    }

    public int getUpdateWait() {
        return this.m_UpdateWait;
    }

    public String updateWaitTipText() {
        return "The time in msec to wait when calling 'updateClassifier'.";
    }

    public void setPredictWait(int value) {
        if (value >= 0) {
            this.m_PredictWait = value;
        } else {
            System.err.println("PredictWait time must be >= 0, provided: " + value);
        }
    }

    public int getPredictWait() {
        return this.m_PredictWait;
    }

    public String predictWaitTipText() {
        return "The time in msec to wait when calling 'classifyInstance'.";
    }

    public void setPredictMin(double value) {
        this.m_PredictMin = value;
    }

    public double getPredictMin() {
        return this.m_PredictMin;
    }

    public String predictMinTipText() {
        return "The minimum value to predict.";
    }

    public void setPredictMax(double value) {
        this.m_PredictMax = value;
    }

    public double getPredictMax() {
        return this.m_PredictMax;
    }

    public String predictMaxTipText() {
        return "The maximum value to predict.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wait(int msec) {
        Long wait = new Long(System.currentTimeMillis());
        int interval = Math.min(100, msec / 10);
        int current = 0;
        while (current < msec) {
            try {
                Long l = wait;
                synchronized (l) {
                    wait.wait(interval);
                }
                current += interval;
            }
            catch (InterruptedException i) {
                break;
            }
            catch (Exception exception) {
            }
        }
    }

    public void buildClassifier(Instances data) throws Exception {
        if (this.m_PredictMin >= this.m_PredictMax) {
            throw new IllegalStateException("PredictMin must be smaller than PredictMax: " + this.m_PredictMin + " !< " + this.m_PredictMax);
        }
        if (this.m_BuildWait > 0) {
            this.wait(this.m_BuildWait);
        }
    }

    protected synchronized Random getRandom() {
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
        return this.m_Random;
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (this.m_UpdateWait > 0) {
            this.wait(this.m_UpdateWait);
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_PredictWait > 0) {
            this.wait(this.m_PredictWait);
        }
        double result = this.getRandom().nextDouble();
        result = result * (this.m_PredictMax - this.m_PredictMin) + this.m_PredictMin;
        return result;
    }

    public String getRevision() {
        return "$Revision$";
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(((Object)((Object)this)).getClass().getName() + "\n");
        result.append(((Object)((Object)this)).getClass().getName().replaceAll(".", "=") + "\n");
        result.append("\n");
        result.append("Min: " + this.getPredictMin() + "\n");
        result.append("Max: " + this.getPredictMax() + "\n");
        return result.toString();
    }

    public static void main(String[] args) {
        FakeClassifier.runClassifier((Classifier)new FakeClassifier(), (String[])args);
    }
}

