/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import adams.core.option.OptionUtils;
import adams.data.instancesanalysis.pls.AbstractPLS;
import adams.data.instancesanalysis.pls.PLS1;
import adams.data.instancesanalysis.pls.PredictionType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.GenericPLSMatrixAccess;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLS;

public class PLSWeighted
extends AbstractClassifier
implements WeightedInstancesHandler,
GenericPLSMatrixAccess {
    private static final long serialVersionUID = 4819775160590973256L;
    protected AbstractPLS m_Algorithm = this.getDefaultAlgorithm();
    protected PLS m_Filter = null;

    public String globalInfo() {
        return "A wrapper classifier for the PLS filter, utilizing the filter's ability to perform predictions.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe PLS algorithm to use. Full classname of filter to include, \tfollowed by scheme options.\n\t(default: " + this.getDefaultAlgorithm().getClass().getName() + ")", "algorithm", 1, "-algorithm <algorithm specification>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-algorithm");
        result.add(OptionUtils.getCommandLine((Object)this.m_Algorithm));
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption((String)"algorithm", (String[])options);
        String[] tmpOptions = Utils.splitOptions((String)tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setAlgorithm((AbstractPLS)OptionUtils.forName(AbstractPLS.class, (String)tmpStr, (String[])tmpOptions));
        } else {
            this.setAlgorithm(this.getDefaultAlgorithm());
        }
    }

    public AbstractPLS getDefaultAlgorithm() {
        PLS1 result = new PLS1();
        result.setPredictionType(PredictionType.ALL);
        return result;
    }

    public void setAlgorithm(AbstractPLS value) {
        this.m_Algorithm = value;
    }

    public AbstractPLS getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The PLS algorithm to be used (only used for setup).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.getAlgorithm().getCapabilities();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(1);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        AbstractPLS pls = (AbstractPLS)OptionUtils.shallowCopy((Object)this.m_Algorithm);
        pls.setPredictionType(PredictionType.EXCEPT_CLASS);
        this.m_Filter = new PLS();
        this.m_Filter.setAlgorithm(pls);
        this.m_Filter.setInputFormat(data);
        Filter.useFilter((Instances)data, (Filter)this.m_Filter);
        pls.setPredictionType(PredictionType.ALL);
    }

    public double classifyInstance(Instance instance) throws Exception {
        this.m_Filter.input(instance);
        this.m_Filter.batchFinished();
        Instance pred = this.m_Filter.output();
        double result = pred.classValue();
        return result;
    }

    @Override
    public String[] getMatrixNames() {
        return this.m_Filter.getMatrixNames();
    }

    @Override
    public Matrix getMatrix(String name) {
        return this.m_Filter.getMatrix(name);
    }

    @Override
    public boolean hasLoadings() {
        return this.m_Filter.hasLoadings();
    }

    @Override
    public Matrix getLoadings() {
        return this.m_Filter.getLoadings();
    }

    public String toString() {
        String result = this.getClass().getName() + "\n" + this.getClass().getName().replaceAll(".", "=") + "\n\n";
        result = result + "Algorithm: " + OptionUtils.getCommandLine((Object)this.m_Algorithm) + "\n";
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        PLSWeighted.runClassifier((Classifier)new PLSWeighted(), (String[])args);
    }
}

