/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import adams.core.option.WekaCommandLineHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.ThreadSafeClassifier;
import weka.classifiers.functions.GPD;
import weka.classifiers.functions.GaussianProcessesNoWeights;
import weka.classifiers.lazy.LWL;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.neighboursearch.FilteredSearch;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.unsupervised.attribute.AddID;
import weka.filters.unsupervised.attribute.RemoveByName;

public class LWLSynchroPrefilter
extends LWL
implements ThreadSafeClassifier {
    static final long serialVersionUID = 1979797405383665815L;
    protected boolean m_NoUpdate;
    protected Filter m_PreFilter = new AllFilter();
    protected Instances m_filtered;
    protected Instances m_original;
    protected boolean m_run = false;
    protected AddID m_addId = new AddID();
    protected NearestNeighbourSearch m_ModifiedSearchMethod = null;
    protected int m_IndexOfID = -1;

    public LWLSynchroPrefilter() {
        this.m_Classifier = new GPD();
    }

    protected void setUp(Instances data) throws Exception {
        if (this.m_run) {
            return;
        }
        this.m_original = data;
        this.m_run = true;
        String attName = "PF_addID";
        if (this.m_PreFilter == null) {
            throw new Exception("No prefilter!");
        }
        this.m_IndexOfID = 0;
        this.m_PreFilter.setInputFormat(data);
        this.m_filtered = Filter.useFilter((Instances)data, (Filter)this.m_PreFilter);
        this.m_addId.setIDIndex("1");
        this.m_addId.setAttributeName(attName);
        this.m_addId.setInputFormat(data);
        Instances m_filtered_addid = Filter.useFilter((Instances)data, (Filter)this.m_addId);
        NearestNeighbourSearch nns = (NearestNeighbourSearch)new SerializedObject((Object)this.getNearestNeighbourSearchAlgorithm()).getObject();
        RemoveByName rbn = new RemoveByName();
        rbn.setExpression(attName);
        MultiFilter mf = new MultiFilter();
        if (nns instanceof FilteredSearch) {
            FilteredSearch f = (FilteredSearch)nns;
            Filter fl = f.getFilter();
            mf.setFilters(new Filter[]{rbn, fl});
        } else {
            mf.setFilters(new Filter[]{rbn});
        }
        FilteredSearch fns = new FilteredSearch();
        fns.setFilter((Filter)mf);
        fns.setDistanceFunction(nns.getDistanceFunction());
        this.m_ModifiedSearchMethod = fns;
        this.m_ModifiedSearchMethod.getDistanceFunction().setAttributeIndices("1-last");
        this.m_ModifiedSearchMethod.getDistanceFunction().setInvertSelection(false);
        this.m_ModifiedSearchMethod.setInstances(m_filtered_addid);
        nns.getDistanceFunction().setAttributeIndices("1-last");
    }

    protected String defaultClassifierString() {
        return GaussianProcessesNoWeights.class.getName();
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_PreFilter = filter;
    }

    public Filter getFilter() {
        return this.m_PreFilter;
    }

    protected String getFilterSpec() {
        Filter c = this.getFilter();
        return c instanceof OptionHandler ? c.getClass().getName() + " " + Utils.joinOptions((String[])c.getOptions()) : c.getClass().getName();
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tSuppresses the update of the nearest neighbor search (nns)\n\talgorithm with the data that is to be classified.\n(default: nns gets updated).\n", "no-update", 0, "-no-update"));
        result.addElement(new Option("\tPre filter).\n", "pre-filter", 1, "-pre-filter <filterspec>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setNoUpdate(Utils.getFlag((String)"no-update", (String[])options));
        String tmp = Utils.getOption((String)"pre-filter", (String[])options);
        if (tmp.isEmpty()) {
            this.setFilter((Filter)new AllFilter());
        } else {
            WekaCommandLineHandler cmd = new WekaCommandLineHandler();
            this.setFilter((Filter)cmd.fromCommandLine(tmp));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getNoUpdate()) {
            result.add("-no-update");
        }
        WekaCommandLineHandler cmd = new WekaCommandLineHandler();
        result.add("-pre-filter");
        result.add(cmd.toCommandLine(this.getFilter()));
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public String noUpdateTipText() {
        return "If turned on, suppresses the update of the nearest-neighbor search algorithm when making predictions (EXPERIMENTAL).";
    }

    public void setNoUpdate(boolean value) {
        this.m_NoUpdate = value;
    }

    public boolean getNoUpdate() {
        return this.m_NoUpdate;
    }

    protected void build(Instance instance) throws Exception {
        int i;
        int i2;
        double bandwidth;
        this.setUp(this.m_Train);
        this.m_addId.input(instance);
        int k = this.m_Train.numInstances();
        if (!this.m_UseAllK && this.m_kNN < k) {
            k = this.m_kNN;
        }
        Instance addedID = this.m_addId.output();
        Instances neighboursInFilteredSpace = this.m_ModifiedSearchMethod.kNearestNeighbours(addedID, k);
        Instances neighbours = new Instances(this.m_filtered, k);
        for (Instance inst : neighboursInFilteredSpace) {
            neighbours.add(this.m_filtered.instance((int)inst.value(this.m_IndexOfID) - 1));
        }
        double[] distances = this.m_ModifiedSearchMethod.getDistances();
        if (this.m_Debug) {
            System.out.println("Test Instance: " + instance);
            System.out.println("For " + k + " kept " + neighbours.numInstances() + " out of " + this.m_Train.numInstances() + " instances.");
        }
        if (k > distances.length) {
            k = distances.length;
        }
        if (this.m_Debug) {
            System.out.println("Instance Distances");
            for (int i3 = 0; i3 < distances.length; ++i3) {
                System.out.println("" + distances[i3]);
            }
        }
        if ((bandwidth = distances[k - 1]) <= 0.0) {
            for (i2 = 0; i2 < distances.length; ++i2) {
                distances[i2] = 1.0;
            }
        } else {
            for (i2 = 0; i2 < distances.length; ++i2) {
                distances[i2] = distances[i2] / bandwidth;
            }
        }
        block12: for (i2 = 0; i2 < distances.length; ++i2) {
            switch (this.m_WeightKernel) {
                case 0: {
                    distances[i2] = 1.0001 - distances[i2];
                    continue block12;
                }
                case 1: {
                    distances[i2] = 0.75 * (1.0001 - distances[i2] * distances[i2]);
                    continue block12;
                }
                case 2: {
                    distances[i2] = Math.pow(1.0001 - Math.pow(distances[i2], 3.0), 3.0);
                    continue block12;
                }
                case 5: {
                    distances[i2] = 1.0;
                    continue block12;
                }
                case 3: {
                    distances[i2] = 1.0 / (1.0 + distances[i2]);
                    continue block12;
                }
                case 4: {
                    distances[i2] = Math.exp(-distances[i2] * distances[i2]);
                }
            }
        }
        if (this.m_Debug) {
            System.out.println("Instance Weights");
            for (i2 = 0; i2 < distances.length; ++i2) {
                System.out.println("" + distances[i2]);
            }
        }
        double sumOfWeights = 0.0;
        double newSumOfWeights = 0.0;
        for (i = 0; i < distances.length; ++i) {
            double weight = distances[i];
            Instance inst = neighbours.instance(i);
            sumOfWeights += inst.weight();
            newSumOfWeights += inst.weight() * weight;
            inst.setWeight(inst.weight() * weight);
        }
        for (i = 0; i < neighbours.numInstances(); ++i) {
            Instance inst = neighbours.instance(i);
            inst.setWeight(inst.weight() * sumOfWeights / newSumOfWeights);
        }
        this.m_Classifier.buildClassifier(neighbours);
    }

    public synchronized double[] distributionForInstance(Instance instance) throws Exception {
        this.build(instance);
        this.m_PreFilter.input(instance);
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(this.m_PreFilter.output());
        }
        if (this.m_Train.numInstances() == 0) {
            throw new Exception("No training instances!");
        }
        if (this.m_Debug) {
            System.out.println("Classifying test instance: " + instance);
            System.out.println("Built base classifier:\n" + this.m_Classifier.toString());
        }
        return this.m_Classifier.distributionForInstance(this.m_PreFilter.output());
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        if (this.m_Train != null && result.indexOf("neighbours") > -1) {
            result.append("\n# of training instances: " + this.m_Train.numInstances() + "\n");
        }
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 12986 $");
    }

    public static void main(String[] argv) {
        LWLSynchroPrefilter.runClassifier((Classifier)new LWLSynchroPrefilter(), (String[])argv);
    }
}

