/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.core.Utils;
import adams.core.base.BaseHostname;
import adams.core.option.OptionUtils;
import gnu.trove.list.array.TByteArrayList;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.meta.socketfacade.AbstractDataPreparation;
import weka.classifiers.meta.socketfacade.Simple;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;

public class SocketFacade
extends AbstractClassifier {
    private static final long serialVersionUID = -7557824847573090857L;
    protected BaseHostname m_Remote = this.getDefaultRemote();
    protected BaseHostname m_Local = this.getDefaultLocal();
    protected int m_Timeout = this.getDefaultTimeout();
    protected AbstractDataPreparation m_Preparation = this.getDefaultPreparation();
    protected boolean m_SkipTrain;
    protected transient ServerSocket m_Server;

    public String globalInfo() {
        return "Uses sockets to communicate with a process for training and making predictions.\nNB: This classifier cannot be evaluated in parallel, as the local port, which receives the results, can only be bound once.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe address of the remote host.\n\t(default: " + this.getDefaultRemote() + ")", "remote", 1, "-remote <host:port>"));
        result.addElement(new Option("\tThe return address for the remote host to use.\n\t(default: " + this.getDefaultLocal() + ")", "local", 1, "-local <host:port>"));
        result.addElement(new Option("\tThe timeout for sockets in milli-second.\n\t(default: " + this.getDefaultTimeout() + ")", "timeout", 1, "-timeout <int>"));
        result.addElement(new Option("\tThe scheme for preparing and parsing the data.\n\t(default: " + Utils.classToString((Object)((Object)this.getDefaultPreparation())) + ")", "preparation", 1, "-preparation <classname + options>"));
        result.addElement(new Option("\tWhether to skip the training process (eg pre-built model).\n\t(default: train not skipped)", "skip-train", 0, "-skip-train"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String value = weka.core.Utils.getOption((String)"remote", (String[])options);
        if (!value.isEmpty()) {
            this.setRemote(new BaseHostname(value));
        } else {
            this.setRemote(this.getDefaultRemote());
        }
        value = weka.core.Utils.getOption((String)"local", (String[])options);
        if (!value.isEmpty()) {
            this.setLocal(new BaseHostname(value));
        } else {
            this.setLocal(this.getDefaultLocal());
        }
        value = weka.core.Utils.getOption((String)"timeout", (String[])options);
        if (!value.isEmpty()) {
            this.setTimeout(Integer.parseInt(value));
        } else {
            this.setTimeout(this.getDefaultTimeout());
        }
        value = weka.core.Utils.getOption((String)"preparation", (String[])options);
        if (!value.isEmpty()) {
            this.setPreparation((AbstractDataPreparation)OptionUtils.forCommandLine(AbstractDataPreparation.class, (String)value));
        } else {
            this.setPreparation(this.getDefaultPreparation());
        }
        this.setSkipTrain(weka.core.Utils.getFlag((String)"skip-train", (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-remote");
        result.add("" + this.getRemote());
        result.add("-local");
        result.add("" + this.getLocal());
        result.add("-timeout");
        result.add("" + this.getTimeout());
        result.add("-preparation");
        result.add(OptionUtils.getCommandLine((Object)((Object)this.getPreparation())));
        if (this.getSkipTrain()) {
            result.add("-skip-train");
        }
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    protected BaseHostname getDefaultRemote() {
        return new BaseHostname("127.0.0.1:8000");
    }

    public void setRemote(BaseHostname value) {
        this.m_Remote = value;
    }

    public BaseHostname getRemote() {
        return this.m_Remote;
    }

    public String remoteTipText() {
        return "The address of the remote process.";
    }

    protected BaseHostname getDefaultLocal() {
        return new BaseHostname("127.0.0.1:8001");
    }

    public void setLocal(BaseHostname value) {
        this.m_Local = value;
    }

    public BaseHostname getLocal() {
        return this.m_Local;
    }

    public String localTipText() {
        return "The return address for the remote process to use.";
    }

    protected int getDefaultTimeout() {
        return 3000;
    }

    public void setTimeout(int value) {
        this.m_Timeout = value;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public String timeoutTipText() {
        return "The timeout in milli-second for waiting on responses from the process.";
    }

    protected AbstractDataPreparation getDefaultPreparation() {
        return new Simple();
    }

    public void setPreparation(AbstractDataPreparation value) {
        this.m_Preparation = value;
    }

    public AbstractDataPreparation getPreparation() {
        return this.m_Preparation;
    }

    public String preparationTipText() {
        return "The data preparation scheme to use for sending/receiving the data.";
    }

    public void setSkipTrain(boolean value) {
        this.m_SkipTrain = value;
    }

    public boolean getSkipTrain() {
        return this.m_SkipTrain;
    }

    public String skipTrainTipText() {
        return "If enabled, the training is skipped; useful when using a pre-built model.";
    }

    protected synchronized void initServer() throws Exception {
        if (this.m_Server == null) {
            this.m_Server = new ServerSocket(this.m_Local.portValue());
            this.m_Server.setSoTimeout(this.m_Timeout);
        }
    }

    protected synchronized void closeServer() {
        if (this.m_Server != null) {
            try {
                this.m_Server.close();
                this.m_Server = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected ServerSocket getServer() throws Exception {
        this.initServer();
        return this.m_Server;
    }

    protected byte[] receive() throws Exception {
        int b;
        this.initServer();
        Socket client = this.m_Server.accept();
        InputStream in = client.getInputStream();
        TByteArrayList result = new TByteArrayList();
        while ((b = in.read()) != -1) {
            result.add((byte)b);
        }
        client.close();
        this.closeServer();
        return result.toArray();
    }

    protected byte[] send(byte[] data) throws Exception {
        this.initServer();
        Socket socket = new Socket(this.m_Remote.hostnameValue(), this.m_Remote.portValue());
        socket.setSoTimeout(this.m_Timeout);
        socket.getOutputStream().write(data);
        socket.getOutputStream().flush();
        socket.close();
        return this.receive();
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        if (this.m_SkipTrain) {
            return;
        }
        try {
            String response = this.m_Preparation.parseTrain(this.send(this.m_Preparation.prepareTrain(data, this)));
            if (response != null) {
                throw new Exception("Failed to perform remote build:\n" + response);
            }
        }
        finally {
            this.closeServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double classifyInstance(Instance instance) throws Exception {
        try {
            double d = this.m_Preparation.parseClassify(this.send(this.m_Preparation.prepareClassify(instance, this)));
            return d;
        }
        finally {
            this.closeServer();
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        try {
            double[] dArray = this.m_Preparation.parseDistribution(this.send(this.m_Preparation.prepareDistribution(instance, this)), instance.numClasses());
            return dArray;
        }
        finally {
            this.closeServer();
        }
    }

    public String toString() {
        return OptionUtils.getCommandLine((Object)((Object)this));
    }
}

