/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ModelOutputHandler;
import weka.core.Utils;
import weka.core.WekaOptionUtils;

public class SuppressModelOutput
extends SingleClassifierEnhancer
implements ModelOutputHandler {
    private static final long serialVersionUID = 6575314591188728994L;
    public static final String SUPPRESS_MODEL_OUTPUT = "suppress-model-output";
    protected boolean m_SuppressModelOutput = false;

    public String globalInfo() {
        return "Meta-classifier that enables the user to suppress the model output.\nUseful for ensembles, since their output can be extremely long.";
    }

    @Override
    public void setSuppressModelOutput(boolean value) {
        this.m_SuppressModelOutput = value;
    }

    @Override
    public boolean getSuppressModelOutput() {
        return this.m_SuppressModelOutput;
    }

    @Override
    public String suppressModelOutputTipText() {
        return "If enabled, suppresses any large model output.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addFlag(result, this.suppressModelOutputTipText(), SUPPRESS_MODEL_OUTPUT);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setSuppressModelOutput(Utils.getFlag((String)SUPPRESS_MODEL_OUTPUT, (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, SUPPRESS_MODEL_OUTPUT, this.getSuppressModelOutput());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_Classifier.buildClassifier(data);
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.m_Classifier.classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_Classifier.distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_SuppressModelOutput) {
            return "Model suppressed";
        }
        return this.m_Classifier.toString();
    }
}

