/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.core.neighboursearch.NewNNSearch;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;
import weka.filters.unsupervised.attribute.PrincipalComponentsJ;

public class PCANNSearch
extends NewNNSearch {
    private static final long serialVersionUID = 1915484723703917241L;
    protected PrincipalComponentsJ m_pca = null;
    protected double m_CoverVariance = 0.95;
    protected int m_MaxAttrsInName = 5;
    protected Instances m_myInstances;
    protected int m_Preprocessing = 1;

    public PCANNSearch() {
    }

    public void setVarianceCovered(double value) {
        this.m_CoverVariance = value;
    }

    public double getVarianceCovered() {
        return this.m_CoverVariance;
    }

    public void setMaximumAttributeNames(int value) {
        this.m_MaxAttrsInName = value;
    }

    public int getMaximumAttributeNames() {
        return this.m_MaxAttrsInName;
    }

    protected Instances transformInstances(Instances in) throws Exception {
        this.m_pca = this.buildFilter(this.m_CoverVariance, this.m_MaxAttrsInName);
        Instances ret = null;
        this.m_pca.setInputFormat(in);
        ret = Filter.useFilter((Instances)in, (Filter)this.m_pca);
        return ret;
    }

    protected Instance transformInstance(Instance in) throws Exception {
        this.m_pca.input(in);
        this.m_pca.batchFinished();
        return this.m_pca.output();
    }

    public PCANNSearch(Instances insts) {
        super(insts);
        try {
            this.m_DistanceFunction.setInstances(this.transformInstances(insts));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PrincipalComponentsJ buildFilter(double cv, int maxatt) {
        PrincipalComponentsJ pcafilter = new PrincipalComponentsJ();
        pcafilter.setMaximumAttributeNames(maxatt);
        pcafilter.setVarianceCovered(cv);
        return pcafilter;
    }

    @Override
    public Instances kNearestNeighbours(Instance target, int kNN) throws Exception {
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        this.m_neighbours.clear();
        double last_distance = Double.POSITIVE_INFINITY;
        Instance t_instance = this.transformInstance(target);
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            double distance;
            if (target == this.m_Instances.instance(i)) continue;
            if (this.m_Stats != null) {
                this.m_Stats.incrPointCount();
            }
            if ((distance = this.m_DistanceFunction.distance(t_instance, this.m_myInstances.instance(i), last_distance, this.m_Stats)) == 0.0 && this.m_SkipIdentical || !(distance < last_distance)) continue;
            this.m_neighbours.add((Object)new NewNNSearch.InstanceNode(i, distance));
            if (this.m_neighbours.size() <= kNN) continue;
            this.m_neighbours.remove(this.m_neighbours.size() - 1);
            last_distance = ((NewNNSearch.InstanceNode)this.m_neighbours.get((int)(this.m_neighbours.size() - 1))).distance;
        }
        Instances neighbours = new Instances(this.m_Instances, this.m_neighbours.size());
        int index = 0;
        this.m_Distances = new double[this.m_neighbours.size()];
        for (NewNNSearch.InstanceNode in : this.m_neighbours) {
            this.m_Distances[index++] = in.distance;
            neighbours.add(this.m_Instances.instance(in.instance_index));
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        return neighbours;
    }

    @Override
    public void setInstances(Instances insts) throws Exception {
        Instances t_instances;
        this.m_Instances = insts;
        this.m_myInstances = t_instances = this.transformInstances(insts);
        this.m_DistanceFunction.setInstances(t_instances);
    }

    @Override
    public void update(Instance ins) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
        this.m_DistanceFunction.update(this.transformInstance(ins));
    }

    @Override
    public void addInstanceInfo(Instance ins) {
        if (this.m_Instances != null) {
            try {
                this.update(ins);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tRetain enough PC attributes to account\n\tfor this proportion of variance in the original data.\n\t(default: 0.95)", "R", 1, "-R <num>"));
        result.addElement(new Option("\tMaximum number of attributes to include in \n\ttransformed attribute names.\n\t(-1 = include all, default: 5)", "A", 1, "-A <num>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public void setPreprocessing(SelectedTag value) {
        if (value.getTags() == PLSFilter.TAGS_PREPROCESSING) {
            this.m_Preprocessing = value.getSelectedTag().getID();
        }
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'R', (String[])options);
        if (tmpStr.length() != 0) {
            this.setVarianceCovered(Double.parseDouble(tmpStr));
        } else {
            this.setVarianceCovered(0.95);
        }
        tmpStr = Utils.getOption((char)'A', (String[])options);
        if (tmpStr.length() != 0) {
            this.setMaximumAttributeNames(Integer.parseInt(tmpStr));
        } else {
            this.setMaximumAttributeNames(5);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        result.add("" + this.getVarianceCovered());
        result.add("-A");
        result.add("" + this.getMaximumAttributeNames());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }
}

