/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import adams.core.io.FlowFile;
import adams.flow.control.SubProcess;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class FlowFilter
extends SimpleBatchFilter {
    private static final long serialVersionUID = 4204884126927666844L;
    protected FlowFile m_FlowFile = new FlowFile(".");
    protected SubProcess m_SubProcess = null;

    public String globalInfo() {
        return "Processes the data with a flow. The flow's outer control actor must be a " + SubProcess.class.getName() + " actor, which takes " + Instances.class.getName() + " as input and generates " + Instances.class.getName() + " again.";
    }

    protected void reset() {
        super.reset();
        if (this.m_SubProcess != null) {
            this.m_SubProcess.destroy();
            this.m_SubProcess = null;
        }
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tThe flow to use for processing the data.\n\t(default: .)", "flow-file", 1, "-flow-file <file>"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-flow-file");
        result.add("" + this.getFlowFile());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption((String)"flow-file", (String[])options);
        if (tmpStr.length() != 0) {
            this.setFlowFile(new FlowFile(tmpStr));
        } else {
            this.setFlowFile(new FlowFile("."));
        }
    }

    public void setFlowFile(FlowFile value) {
        this.m_FlowFile = value;
    }

    public FlowFile getFlowFile() {
        return this.m_FlowFile;
    }

    public String flowFileTipText() {
        return "The flow to process the data with.";
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    public Capabilities getCapabilities() {
        return super.getCapabilities();
    }

    protected Instances process(Instances instances) throws Exception {
        String msg;
        Instances result = null;
        if (!this.m_FirstBatchDone) {
            if (this.m_FlowFile.isDirectory()) {
                throw new IllegalStateException("No flow file defined: " + this.m_FlowFile);
            }
            this.m_SubProcess = (SubProcess)ActorUtils.read((String)this.m_FlowFile.getAbsolutePath());
            msg = this.m_SubProcess.setUp();
            if (msg != null) {
                throw new IllegalStateException(msg);
            }
        }
        this.m_SubProcess.input(new Token((Object)instances));
        msg = this.m_SubProcess.execute();
        if (msg == null) {
            if (this.m_SubProcess.hasPendingOutput()) {
                result = (Instances)this.m_SubProcess.output().getPayload();
            } else {
                throw new IllegalStateException("Flow did not generate any data!");
            }
        }
        this.m_SubProcess.wrapUp();
        if (!this.m_FirstBatchDone && result != null) {
            this.setOutputFormat(new Instances(result));
        }
        return result;
    }
}

