/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class RowSum
extends SimpleStreamFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -8798054963031276516L;

    public String globalInfo() {
        return "Sums up all numeric values in a row and replaces them with it.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.disableAllAttributes();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("Sum"));
        if (inputFormat.classIndex() > -1) {
            atts.add((Attribute)inputFormat.classAttribute().copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (inputFormat.classIndex() > -1) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        double sum = 0.0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex() || !instance.attribute(i).isNumeric()) continue;
            sum += instance.value(i);
        }
        double[] values = new double[this.outputFormatPeek().numAttributes()];
        values[0] = sum;
        if (values.length > 1) {
            values[1] = instance.classValue();
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        result.setDataset(this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        RowSum.runFilter((Filter)new RowSum(), (String[])args);
    }
}

