/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.data.weka.WekaAttributeIndex;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveDuplicateIDs
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -7024951985782351356L;
    protected WekaAttributeIndex m_ID = new WekaAttributeIndex("first");

    public String globalInfo() {
        return "Removes rows with IDs that occur multiple times.\nAlso skips rows with missing ID.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe index/name of ID attribute to use for identifying duplicates.\n", "id", 1, "-id <1-based index or name>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"id", (String[])options);
        if (tmpStr.isEmpty()) {
            this.setID(new WekaAttributeIndex(tmpStr));
        } else {
            this.setID(new WekaAttributeIndex("first"));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-id");
        result.add("" + this.getID().getIndex());
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public void setID(WekaAttributeIndex value) {
        this.m_ID = value;
    }

    public WekaAttributeIndex getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The attribute name or index of the attribute with the IDs; " + this.m_ID.getExample();
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.disable(Capabilities.Capability.RELATIONAL_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_ID.setData(inputFormat);
        if (this.m_ID.getIntIndex() == -1) {
            throw new IllegalStateException("Attribute name/index not found: " + (Object)((Object)this.m_ID));
        }
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        String id;
        Instances result = new Instances(instances, instances.numInstances());
        int index = this.m_ID.getIntIndex();
        boolean numeric = instances.attribute(index).isNumeric();
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (Instance inst : instances) {
            if (inst.isMissing(index)) continue;
            id = numeric ? "" + inst.value(index) : inst.stringValue(index);
            if (ids.contains(id)) {
                duplicates.add(id);
            }
            ids.add(id);
        }
        if (this.m_Debug) {
            System.out.println("Duplicate IDs: " + duplicates);
        }
        for (Instance inst : instances) {
            if (inst.isMissing(index) || duplicates.contains(id = numeric ? "" + inst.value(index) : inst.stringValue(index))) continue;
            result.add((Instance)inst.copy());
        }
        result.compactify();
        if (this.m_Debug) {
            System.out.println("Reduction: " + instances.numInstances() + " -> " + result.numInstances());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        RemoveDuplicateIDs.runFilter((Filter)new RemoveDuplicateIDs(), (String[])args);
    }
}

