/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetToWekaInstancesTest
extends AbstractConversionTestCase {
    public SpreadSheetToWekaInstancesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.copyResourceToTmp("labor.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("labor.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result = new SpreadSheet[2];
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        result[0] = reader.read(new TmpFile("bolts.csv").getAbsolutePath());
        result[1] = reader.read(new TmpFile("labor.csv").getAbsolutePath());
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetToWekaInstances[] result = new SpreadSheetToWekaInstances[]{new SpreadSheetToWekaInstances(), new SpreadSheetToWekaInstances()};
        result[1].setMaxLabels(2);
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetToWekaInstancesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetToWekaInstancesTest.runTest((Test)SpreadSheetToWekaInstancesTest.suite());
    }
}

