/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import adams.data.instancesanalysis.pls.AbstractPLS;
import adams.data.instancesanalysis.pls.PLS1;
import adams.data.instancesanalysis.pls.PreprocessingType;
import adams.data.instancesanalysis.pls.SIMPLS;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLS;

public class PLSTest
extends AbstractAdamsFilterTest {
    protected static final int NUM_ATTS = 5;
    protected static final int NUM_NUMERIC_ATTS = 20;

    public PLSTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        return this.getFilter(5, (AbstractPLS)new PLS1());
    }

    public Filter getFilter(int numAtts, AbstractPLS algorithm) {
        PLS filter = new PLS();
        algorithm.setNumComponents(numAtts);
        algorithm.setNumComponents(numAtts);
        algorithm.setReplaceMissing(true);
        algorithm.setPreprocessingType(PreprocessingType.CENTER);
        filter.setAlgorithm(algorithm);
        return filter;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = new TestInstances();
        test.setNumNominal(0);
        test.setNumNumeric(20);
        test.setClassType(0);
        Instances result = test.generate();
        return result;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestInstances test = new TestInstances();
        test.setNumNominal(0);
        test.setNumNumeric(20);
        test.setClassType(0);
        this.m_Instances = test.generate();
    }

    protected void performTest(AbstractPLS algorithm) {
        Instances icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter(5, algorithm);
        Instances result = this.useFilter();
        PLSTest.assertEquals((int)result.numAttributes(), (int)6);
        PLSTest.assertEquals((int)result.numInstances(), (int)icopy.numInstances());
        this.m_Filter = this.getFilter(10, algorithm);
        result = this.useFilter();
        PLSTest.assertEquals((int)result.numAttributes(), (int)11);
        PLSTest.assertEquals((int)result.numInstances(), (int)icopy.numInstances());
    }

    public void testPLS1() {
        this.performTest((AbstractPLS)new PLS1());
    }

    public void testSIMPLS() {
        this.performTest((AbstractPLS)new SIMPLS());
    }

    public static Test suite() {
        return new TestSuite(PLSTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)PLSTest.suite());
    }
}

