/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.LogTransform;
import weka.test.AdamsTestHelper;

public class LogTransformTest
extends AbstractAdamsFilterTest {
    public LogTransformTest(String name) {
        super(name);
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(0);
        testinst.setNumNumeric(20);
        testinst.setClassType(1);
        testinst.setNumInstances(50);
        return testinst.generate();
    }

    public Filter getFilter() {
        return this.getFilter("first-last", true);
    }

    public Filter getFilter(String range, boolean addone) {
        LogTransform result = new LogTransform();
        result.setAttributeRange(range);
        result.setAddOne(addone);
        return result;
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogTransformTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            LogTransformTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogTransformTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        LogTransformTest.assertEquals((int)icopy.numAttributes(), (int)result.numAttributes());
        LogTransformTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public void testFirst() {
        this.m_Filter = this.getFilter("first", true);
        this.testBuffered();
        this.performTest();
    }

    public void testFirst3() {
        this.m_Filter = this.getFilter("1-3", true);
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(LogTransformTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)LogTransformTest.suite());
    }
}

