/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.io.FileUtils;
import adams.core.management.AbstractEnvironmentModifier;
import adams.env.Environment;
import java.io.File;
import java.util.List;
import weka.core.Version;

public class WekaHomeEnvironmentModifier
extends AbstractEnvironmentModifier {
    private static final long serialVersionUID = 900388473930981697L;
    public static final String ENV_VAR = "WEKA_HOME";

    public String globalInfo() {
        return "Sets the WEKA_HOME environment variable to if not already present in the environment:\n<project-home>/wekafiles/<weka-version>";
    }

    public boolean updateEnvironment(List<String> env) {
        for (String var : env) {
            if (!var.startsWith("WEKA_HOME=")) continue;
            this.getLogger().warning("Environment variable WEKA_HOME already present, not overriding.");
            return false;
        }
        String path = Environment.getInstance().getHome() + File.separator + "wekafiles" + File.separator + FileUtils.createFilename((String)Version.VERSION, (String)"_");
        File dir = new File(path);
        if (!dir.exists()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Creating directory: " + path);
            }
            if (!dir.mkdirs()) {
                this.getLogger().warning("Failed to create directory: " + path);
                return false;
            }
        }
        env.add("WEKA_HOME=" + path);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("WEKA_HOME: " + path);
        }
        return true;
    }
}

