/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.discovery.PropertyPath;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.conversion.AbstractSwapObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.logging.Level;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLS;
import weka.filters.supervised.attribute.PLSFilter;

public class SwapPLS
extends AbstractSwapObject {
    private static final long serialVersionUID = -1837107962029937245L;
    protected Filter m_OldFilter;
    protected boolean m_ExactMatch;
    protected Filter m_NewFilter;
    protected boolean m_KeepNumComponents;
    protected transient String m_OldFilterCommandLine;

    public String globalInfo() {
        return "Swaps one PLS filter for another.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("old-filter", "oldFilter", (Object)new PLSFilter());
        this.m_OptionManager.add("exact-match", "exactMatch", (Object)false);
        this.m_OptionManager.add("new-filter", "newFilter", (Object)new PLS());
        this.m_OptionManager.add("keep-num-components", "keepNumComponents", (Object)true);
    }

    protected void reset() {
        super.reset();
        this.m_OldFilterCommandLine = null;
    }

    public void setOldFilter(Filter value) {
        if (this.isPLSFilter(value)) {
            this.m_OldFilter = value;
            this.reset();
        } else {
            this.getLogger().warning("Not a PLS filter: " + OptionUtils.getCommandLine((Object)value));
        }
    }

    public Filter getOldFilter() {
        return this.m_OldFilter;
    }

    public String oldFilterTipText() {
        return "The old PLS filter to replace.";
    }

    public void setExactMatch(boolean value) {
        this.m_ExactMatch = value;
        this.reset();
    }

    public boolean getExactMatch() {
        return this.m_ExactMatch;
    }

    public String exactMatchTipText() {
        return "If enabled, then the complete command-line is used for comparison rather than just the class name.";
    }

    public void setNewFilter(Filter value) {
        if (this.isPLSFilter(value)) {
            this.m_NewFilter = value;
            this.reset();
        } else {
            this.getLogger().warning("Not a PLS filter: " + OptionUtils.getCommandLine((Object)value));
        }
    }

    public Filter getNewFilter() {
        return this.m_NewFilter;
    }

    public String newFilterTipText() {
        return "The new PLS filter to replace with.";
    }

    public void setKeepNumComponents(boolean value) {
        this.m_KeepNumComponents = value;
        this.reset();
    }

    public boolean getKeepNumComponents() {
        return this.m_KeepNumComponents;
    }

    public String keepNumComponentsTipText() {
        return "If enabled, then the 'number of components' of the old filter are retained.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"oldFilter", (Object)this.m_OldFilter, (String)"old: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"exactMatch", (Object)(this.m_ExactMatch ? "exact" : "just class"), (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"newFilter", (Object)this.m_NewFilter, (String)", new: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keepNumComponents", (Object)(this.m_KeepNumComponents ? "keep #comps" : "update #comps"), (String)", ");
        return result;
    }

    protected boolean isPLSFilter(Filter filter) {
        return filter instanceof PLSFilter || filter instanceof PLS;
    }

    protected int getNumComponents(Object filter) {
        if (filter instanceof PLSFilter) {
            return ((PLSFilter)filter).getNumComponents();
        }
        if (filter instanceof PLS) {
            return ((PLS)filter).getAlgorithm().getNumComponents();
        }
        return -1;
    }

    protected boolean setNumComponents(Object filter, int numComponents) {
        if (filter instanceof PLSFilter) {
            ((PLSFilter)filter).setNumComponents(numComponents);
            return true;
        }
        if (filter instanceof PLS) {
            ((PLS)filter).getAlgorithm().setNumComponents(numComponents);
            return true;
        }
        return false;
    }

    protected boolean canSwap(PropertyPath.Path path, PropertyDescriptor desc, Object parent, Object child) {
        if (child == null || desc == null) {
            return false;
        }
        if (this.m_ExactMatch) {
            if (this.m_OldFilterCommandLine == null) {
                this.m_OldFilterCommandLine = OptionUtils.getCommandLine((Object)this.m_OldFilter);
            }
            return this.m_OldFilterCommandLine.equals(OptionUtils.getCommandLine((Object)child));
        }
        return this.m_OldFilter.getClass().equals(child.getClass());
    }

    protected boolean performSwap(PropertyPath.Path path, PropertyDescriptor desc, Object parent, Object child) {
        int index;
        Object newFilter = ObjectCopyHelper.copyObject((Object)this.m_NewFilter);
        if (this.m_KeepNumComponents) {
            int numComps = this.getNumComponents(child);
            if (numComps == -1) {
                this.getLogger().warning("Failed to obtain number of components from: " + OptionUtils.getCommandLine((Object)child));
            } else if (!this.setNumComponents(newFilter, numComps)) {
                this.getLogger().warning("Failed to set number of components in: " + OptionUtils.getCommandLine((Object)newFilter));
            }
        }
        if ((index = path.get(path.size() - 1).getIndex()) > -1) {
            try {
                Method method = desc.getReadMethod();
                Object array = method.invoke(parent, new Object[0]);
                Array.set(array, index, newFilter);
                method = desc.getWriteMethod();
                method.invoke(parent, array);
                return true;
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to update filter (" + path + ")!", (Throwable)e);
                return false;
            }
        }
        try {
            Method method = desc.getWriteMethod();
            method.invoke(parent, newFilter);
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to update filter (" + path + ")!", (Throwable)e);
            return false;
        }
    }
}

