/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instances;

import adams.core.Utils;
import java.io.Serializable;
import java.util.Comparator;
import weka.core.Instance;
import weka.core.Instances;

public class InstanceComparator
implements Serializable,
Comparator<Instance> {
    private static final long serialVersionUID = 7477661638560986045L;
    protected int[] m_Indices;
    protected boolean[] m_Ascending;

    public InstanceComparator(int[] indices) {
        this(indices, null);
    }

    public InstanceComparator(int[] indices, boolean[] ascending) {
        if (indices == null) {
            throw new IllegalArgumentException("Indices cannot be null!");
        }
        if (ascending == null) {
            ascending = new boolean[indices.length];
            for (int i = 0; i < ascending.length; ++i) {
                ascending[i] = true;
            }
        }
        if (indices.length != ascending.length) {
            throw new IllegalArgumentException("Length of indices and sorting order differ: " + indices.length + " != " + ascending.length);
        }
        this.m_Indices = (int[])indices.clone();
        this.m_Ascending = (boolean[])ascending.clone();
    }

    public int[] getIndices() {
        return this.m_Indices;
    }

    public boolean[] getAscending() {
        return this.m_Ascending;
    }

    @Override
    public int compare(Instance o1, Instance o2) {
        int weight;
        int result = 0;
        Instances header = o1.dataset();
        for (int i = 0; result == 0 && i < this.m_Indices.length; result *= weight, ++i) {
            double d2;
            double d1;
            result = o1.isMissing(this.m_Indices[i]) && o2.isMissing(this.m_Indices[i]) ? 0 : (o1.isMissing(this.m_Indices[i]) ? -1 : (o2.isMissing(this.m_Indices[i]) ? 1 : (header.attribute(this.m_Indices[i]).isNumeric() ? ((d1 = o1.value(this.m_Indices[i])) < (d2 = o2.value(this.m_Indices[i])) ? -1 : (d1 == d2 ? 0 : 1)) : o1.stringValue(this.m_Indices[i]).compareTo(o2.stringValue(this.m_Indices[i])))));
            if (!this.m_Ascending[i]) {
                result = -result;
            }
            weight = (int)Math.pow(10.0, this.m_Indices.length - i);
        }
        return result;
    }

    public String toString() {
        return "indices=" + Utils.arrayToString((Object)this.m_Indices) + ", asc=" + Utils.arrayToString((Object)this.m_Ascending);
    }
}

