/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instancesanalysis;

import adams.core.Range;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.conversion.WekaInstancesToSpreadSheet;
import adams.data.instancesanalysis.AbstractInstancesAnalysis;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.weka.WekaAttributeRange;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.PartitionedMultiFilter2;
import weka.filters.unsupervised.attribute.PublicPrincipalComponents;
import weka.filters.unsupervised.attribute.Remove;

public class PCA
extends AbstractInstancesAnalysis {
    private static final long serialVersionUID = 7150143741822676345L;
    protected WekaAttributeRange m_AttributeRange;
    protected double m_Variance;
    protected int m_MaxAttributes;
    protected int m_MaxAttributeNames;
    protected boolean m_SkipNominal;
    protected SpreadSheet m_Loadings;
    protected SpreadSheet m_Scores;
    protected TIntList m_Supported;
    protected TIntList m_Unsupported;
    protected ArrayList<Integer> m_Kept;
    protected int m_NumAttributes;

    public String globalInfo() {
        return "Performs principal components analysis and allows access to loadings and scores.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("attribute-range", "attributeRange", (Object)new WekaAttributeRange("first-last"));
        this.m_OptionManager.add("variance", "variance", (Object)0.95, (Number)0.0, null);
        this.m_OptionManager.add("max-attributes", "maxAttributes", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-attribute-names", "maxAttributeNames", (Object)5, (Number)-1, null);
        this.m_OptionManager.add("skip-nominal", "skipNominal", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_Loadings = null;
        this.m_Scores = null;
        this.m_Supported = null;
        this.m_Unsupported = null;
        this.m_Kept = null;
        this.m_NumAttributes = 0;
    }

    public void setAttributeRange(WekaAttributeRange value) {
        this.m_AttributeRange = value;
        this.reset();
    }

    public WekaAttributeRange getAttributeRange() {
        return this.m_AttributeRange;
    }

    public String attributeRangeTipText() {
        return "The range of attributes to process.";
    }

    public void setVariance(double value) {
        if (this.getOptionManager().isValid("variance", (Number)value)) {
            this.m_Variance = value;
            this.reset();
        }
    }

    public double getVariance() {
        return this.m_Variance;
    }

    public String varianceTipText() {
        return "The variance to cover.";
    }

    public void setMaxAttributes(int value) {
        if (this.getOptionManager().isValid("maxAttributes", (Number)value)) {
            this.m_MaxAttributes = value;
            this.reset();
        }
    }

    public int getMaxAttributes() {
        return this.m_MaxAttributes;
    }

    public String maxAttributesTipText() {
        return "The maximum attributes.";
    }

    public void setMaxAttributeNames(int value) {
        if (this.getOptionManager().isValid("maxAttributeNames", (Number)value)) {
            this.m_MaxAttributeNames = value;
            this.reset();
        }
    }

    public int getMaxAttributeNames() {
        return this.m_MaxAttributeNames;
    }

    public String maxAttributeNamesTipText() {
        return "The maximum number of attribute names.";
    }

    public void setSkipNominal(boolean value) {
        this.m_SkipNominal = value;
        this.reset();
    }

    public boolean getSkipNominal() {
        return this.m_SkipNominal;
    }

    public String skipNominalTipText() {
        return "If enabled, NOMINAL attributes won't get processed by the PCA filter by turning them into STRING attributes.";
    }

    protected void check(Instances data) {
        super.check((Object)data);
        this.m_AttributeRange.setData(data);
        if (this.m_AttributeRange.getIntIndices().length == 0) {
            throw new IllegalStateException("No attributes selected with range: " + this.m_AttributeRange.getRange());
        }
    }

    protected SpreadSheet extractLoadings(Instances data, ArrayList<ArrayList<Double>> coeff) {
        int n;
        int i;
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < coeff.size(); ++i) {
            row.addCell("L" + (i + 1)).setContent("Loading-" + (i + 1));
        }
        row.addCell("I").setContent("Index");
        row.addCell("A").setContent("Attribute");
        for (n = 0; n < this.m_NumAttributes; ++n) {
            row = result.addRow();
            row.addCell("I").setContent(Integer.valueOf(n + 1));
            row.addCell("A").setContent(data.attribute(n).name());
        }
        for (i = 0; i < coeff.size(); ++i) {
            for (n = 0; n < this.m_NumAttributes; ++n) {
                row = result.getRow(n);
                if (this.m_Kept.contains(n)) {
                    int index = this.m_Kept.indexOf(n);
                    if (index < coeff.get(i).size()) {
                        double value = coeff.get(i).get(index);
                        row.addCell("L" + (i + 1)).setContent(Double.valueOf(value));
                        continue;
                    }
                    row.addCell("L" + (i + 1)).setContent(Integer.valueOf(0));
                    continue;
                }
                row.addCell("L" + (i + 1)).setContent(Integer.valueOf(0));
            }
        }
        return result;
    }

    protected String doAnalyze(Instances data) throws Exception {
        int i;
        String result = null;
        this.m_Loadings = null;
        this.m_Scores = null;
        if (!this.m_AttributeRange.isAllRange()) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Filtering attribute range: " + this.m_AttributeRange.getRange());
            }
            Remove remove = new Remove();
            remove.setAttributeIndicesArray(this.m_AttributeRange.getIntIndices());
            remove.setInvertSelection(true);
            remove.setInputFormat(data);
            data = Filter.useFilter((Instances)data, (Filter)remove);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Performing PCA...");
        }
        TIntArrayList listNominal = new TIntArrayList();
        if (this.m_SkipNominal) {
            for (i = 0; i < data.numAttributes(); ++i) {
                if (i == data.classIndex() || !data.attribute(i).isNominal()) continue;
                listNominal.add(i);
            }
        }
        Capabilities caps = new PublicPrincipalComponents().getCapabilities();
        this.m_Supported = new TIntArrayList();
        this.m_Unsupported = new TIntArrayList();
        for (i = 0; i < data.numAttributes(); ++i) {
            if (!caps.test(data.attribute(i)) || i == data.classIndex() || listNominal.contains(i)) {
                this.m_Unsupported.add(i);
                continue;
            }
            this.m_Supported.add(i);
        }
        data.setClassIndex(-1);
        this.m_NumAttributes = this.m_Supported.size();
        this.m_Kept = new ArrayList();
        for (i = 0; i < this.m_Supported.size(); ++i) {
            if (data.numDistinctValues(this.m_Supported.get(i)) <= 1) continue;
            this.m_Kept.add(this.m_Supported.get(i));
        }
        PublicPrincipalComponents pca = new PublicPrincipalComponents();
        pca.setMaximumAttributes(this.m_MaxAttributes);
        pca.setVarianceCovered(this.m_Variance);
        pca.setMaximumAttributeNames(this.m_MaxAttributeNames);
        PartitionedMultiFilter2 part = null;
        if (this.m_Unsupported.size() > 0) {
            Range rangeUnsupported = new Range();
            rangeUnsupported.setMax(data.numAttributes());
            rangeUnsupported.setIndices(this.m_Unsupported.toArray());
            Range rangeSupported = new Range();
            rangeSupported.setMax(data.numAttributes());
            rangeSupported.setIndices(this.m_Supported.toArray());
            part = new PartitionedMultiFilter2();
            part.setFilters(new Filter[]{pca, new AllFilter()});
            part.setRanges(new weka.core.Range[]{new weka.core.Range(rangeSupported.getRange()), new weka.core.Range(rangeUnsupported.getRange())});
        }
        try {
            if (part != null) {
                part.setInputFormat(data);
            } else {
                pca.setInputFormat(data);
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to set data format", (Throwable)e);
        }
        SpreadSheet transformed = null;
        if (result == null) {
            Instances filtered;
            try {
                filtered = part != null ? Filter.useFilter((Instances)data, part) : Filter.useFilter((Instances)data, (Filter)pca);
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to apply filter", (Throwable)e);
                filtered = null;
            }
            if (filtered != null) {
                WekaInstancesToSpreadSheet conv = new WekaInstancesToSpreadSheet();
                conv.setInput(filtered);
                result = conv.convert();
                if (result == null) {
                    transformed = (SpreadSheet)conv.getOutput();
                    if (part != null) {
                        for (i = 0; i < transformed.getColumnCount(); ++i) {
                            String colName = transformed.getColumnName(i);
                            colName = colName.replaceFirst("filtered-[0-9]*-", "");
                            transformed.getHeaderRow().getCell(i).setContentAsString(colName);
                        }
                    }
                }
            }
        }
        if (result == null) {
            this.m_Scores = transformed;
            ArrayList<ArrayList<Double>> coeff = pca.getCoefficients();
            this.m_Loadings = this.extractLoadings(data, coeff);
            this.m_Loadings.setName("Loadings for " + data.relationName());
        }
        return result;
    }

    public SpreadSheet getLoadings() {
        return this.m_Loadings;
    }

    public SpreadSheet getScores() {
        return this.m_Scores;
    }
}

