/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.io.PlaceholderFile;
import adams.core.option.JsonConsumer;
import adams.data.io.input.AbstractAdamsExperimentReader;
import adams.data.io.output.AbstractAdamsExperimentWriter;
import adams.data.io.output.JsonAdamsExperimentWriter;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractExperiment;
import java.io.File;
import java.util.logging.Level;

public class JsonAdamsExperimentReader
extends AbstractAdamsExperimentReader {
    private static final long serialVersionUID = 7175000296488786947L;

    public String globalInfo() {
        return "Reads ADAMS Experiments in JSON format.";
    }

    @Override
    public String getFormatDescription() {
        return "JSON experiment";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"expjson"};
    }

    @Override
    public AbstractAdamsExperimentWriter getCorrespondingWriter() {
        return new JsonAdamsExperimentWriter();
    }

    @Override
    protected AbstractExperiment doRead(PlaceholderFile file) {
        try {
            return (AbstractExperiment)new JsonConsumer().fromFile((File)file);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load experiment from: " + file, (Throwable)e);
            return null;
        }
    }
}

